/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.MyWorkbook;
import cn.renlm.plugins.MyExcel.entity.CheckResult;
import cn.renlm.plugins.MyExcel.handler.DataReadHandler;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractReader {
    final Map<String, Integer> read = new LinkedHashMap<String, Integer>();
    final MyWorkbook myExcel;
    final byte[] bytes;

    public abstract AbstractReader read(String var1, DataReadHandler var2);

    public abstract AbstractReader readBySax(String var1, DataReadHandler var2);

    public int getRead(String sheetName) {
        return (Integer)ObjectUtil.defaultIfNull((Object)this.read.get(sheetName), (Object)0);
    }

    public AbstractReader(MyWorkbook myExcel, InputStream in) {
        this.myExcel = myExcel;
        this.bytes = IoUtil.readBytes((InputStream)in);
    }

    final void processRow(MyWorkbook myExcel, List<List<String>> titles, List<String> keys, DataReadHandler dataReadHandler, MySheet sheet, long rowIndex, List<Object> rowList) {
        boolean isBlank = true;
        for (Object obj : rowList) {
            if (StrUtil.isBlankIfStr((Object)obj)) continue;
            isBlank = false;
        }
        if (isBlank) {
            return;
        }
        int sheetLevel = sheet.level();
        long level = rowIndex - (long)sheet.getStart() + 1L;
        this.read.put(sheet.getName(), this.getRead(sheet.getName()) + 1);
        if (level >= 1L) {
            if (level <= (long)sheetLevel) {
                titles.add(MySheet.fillTitle(rowList));
                if (level == (long)sheetLevel) {
                    keys.addAll(sheet.generateKeys(titles, dataReadHandler));
                }
            } else {
                Map data = CollUtil.zip(keys, rowList);
                data.remove("");
                CheckResult checkResult = dataReadHandler.readConvert(sheet, rowIndex, data);
                dataReadHandler.handle(data, checkResult);
            }
        }
    }
}

