/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.selenium;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import cn.renlm.plugins.MyCrawler.selenium.MyChromeDriver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChromeDriverPool {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverPool.class);
    private static final int STAT_RUNNING = 1;
    private static final int STAT_CLODED = 2;
    private AtomicInteger stat = new AtomicInteger(1);
    private List<MyChromeDriver> webDriverList = Collections.synchronizedList(new ArrayList());
    private BlockingDeque<MyChromeDriver> innerQueue = new LinkedBlockingDeque<MyChromeDriver>();
    private final Setting chromeSetting;
    private final int capacity;
    private MyChromeDriver mDriver = null;

    public ChromeDriverPool(Setting chromeSetting, int capacity) {
        this.chromeSetting = chromeSetting;
        this.capacity = NumberUtil.max((int[])new int[]{capacity, 1});
    }

    public void configure() throws IOException {
        boolean headless = this.chromeSetting.getBool((Object)"headless", Boolean.valueOf(false));
        String userAgent = this.chromeSetting.getStr((Object)"userAgent");
        String windowSize = this.chromeSetting.getStr("windowSize", "1280,720");
        String driverPath = this.chromeSetting.getStr((Object)"driverPath");
        if (!StrUtil.equals((CharSequence)driverPath, (CharSequence)System.getProperty("webdriver.chrome.driver"))) {
            System.setProperty("webdriver.chrome.driver", driverPath);
        }
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(headless);
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--window-size=" + windowSize});
        options.setExperimentalOption("excludeSwitches", (Object)CollUtil.newArrayList((Object[])new String[]{"enable-automation"}));
        if (StrUtil.isNotBlank((CharSequence)userAgent)) {
            options.addArguments(new String[]{"--user-agent=" + userAgent});
        }
        ChromeDriverService service = ChromeDriverService.createDefaultService();
        ChromeDriver chromeDriver = new ChromeDriver(service, options);
        this.mDriver = new MyChromeDriver(chromeDriver, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyChromeDriver get() throws InterruptedException {
        this.checkRunning();
        MyChromeDriver poll = this.innerQueue.poll();
        if (poll != null) {
            return poll;
        }
        if (this.webDriverList.size() < this.capacity) {
            List<MyChromeDriver> list = this.webDriverList;
            synchronized (list) {
                if (this.webDriverList.size() < this.capacity) {
                    try {
                        this.configure();
                        this.innerQueue.add(this.mDriver);
                        this.webDriverList.add(this.mDriver);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.innerQueue.take();
    }

    public void returnToPool(MyChromeDriver webDriver) {
        this.checkRunning();
        this.innerQueue.add(webDriver);
    }

    protected void checkRunning() {
        if (!this.stat.compareAndSet(1, 1)) {
            throw new IllegalStateException("Already closed!");
        }
    }

    public void closeAll() {
        if (!this.stat.compareAndSet(1, 2)) {
            throw new IllegalStateException("Already closed!");
        }
        for (MyChromeDriver myChromeDriver : this.webDriverList) {
            ChromeDriver webDriver = myChromeDriver.getWebDriver();
            ChromeDriverService service = myChromeDriver.getService();
            log.info("Quit webDriver" + (WebDriver)webDriver);
            webDriver.quit();
            service.stop();
        }
    }
}

