/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.reader;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.exceptions.POIException;
import cn.renlm.plugins.MyExcel.config.MyColumn;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.MyWorkbook;
import cn.renlm.plugins.MyExcel.handler.DataReadHandler;
import cn.renlm.plugins.MyExcel.reader.AbstractReader;
import cn.renlm.plugins.MyExcel.util.MergeUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XlsxReader
extends AbstractReader
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private MySheet mySheet;
    private DataReadHandler dataReadHandler;
    protected StylesTable styles;
    private SharedStrings strings;
    private String firstSheetName;
    private Map<String, byte[]> sheetMap = new LinkedHashMap<String, byte[]>();
    private Map<String, Comments> sheetCommentsMap = new LinkedHashMap<String, Comments>();
    private int rowNum;
    private int colNum;
    final List<List<String>> titles = new ArrayList<List<String>>();
    final List<String> keys = new ArrayList<String>();
    private List<Object> rowCells = new ArrayList<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XlsxReader(MyWorkbook myExcel, InputStream in) {
        super(myExcel, in);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.bytes);
        try {
            try (OPCPackage opcPackage = OPCPackage.open((InputStream)inputStream);){
                XSSFReader xssfReader = new XSSFReader(opcPackage);
                this.styles = xssfReader.getStylesTable();
                this.strings = xssfReader.getSharedStringsTable();
                XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
                while (iter.hasNext()) {
                    InputStream stream = iter.next();
                    try {
                        String sheetName = iter.getSheetName();
                        this.sheetCommentsMap.put(sheetName, (Comments)iter.getSheetComments());
                        this.sheetMap.put(sheetName, IoUtil.readBytes((InputStream)stream));
                        this.firstSheetName = (String)ObjectUtil.defaultIfBlank((CharSequence)this.firstSheetName, (CharSequence)sheetName);
                    }
                    finally {
                        if (Collections.singletonList(stream).get(0) == null) continue;
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
            catch (InvalidFormatException e) {
                throw new POIException((Throwable)e);
            }
        }
        finally {
            if (Collections.singletonList(inputStream).get(0) != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractReader read(String sheetName, DataReadHandler dataReadHandler) {
        XlsxReader xlsxReader;
        block8: {
            this.mySheet = this.myExcel.getSheetByName(sheetName);
            this.dataReadHandler = dataReadHandler;
            ByteArrayInputStream in = new ByteArrayInputStream(this.bytes);
            try {
                ExcelReader reader = ExcelUtil.getReader((InputStream)in, (int)0);
                List sheetNames = reader.getSheetNames();
                if (sheetNames.contains(sheetName)) {
                    reader.setSheet(sheetName);
                } else {
                    reader.setSheet(0);
                }
                AtomicInteger rowIndex = new AtomicInteger(0);
                reader.read((cell, value) -> {
                    int rIndex = cell.getRowIndex();
                    int cIndex = cell.getColumnIndex();
                    if (!NumberUtil.equals((long)rowIndex.get(), (long)rIndex)) {
                        super.processRow(this.myExcel, this.titles, this.keys, dataReadHandler, this.mySheet, rowIndex.getAndIncrement(), this.rowCells);
                        this.rowCells.clear();
                    }
                    if (value == null) {
                        this.addToRowCells(rIndex, cIndex, value);
                    } else {
                        Sheet sh = cell.getSheet();
                        Cell _cell = MergeUtil.findFirstCellOfUnitRegion(sh, rIndex, cIndex);
                        Object _value = CellUtil.getCellValue((Cell)_cell);
                        this.addToRowCells(rIndex, cIndex, _value);
                    }
                });
                xlsxReader = this;
                if (Collections.singletonList(in).get(0) == null) break block8;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(in).get(0) != null) {
                    ((InputStream)in).close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        return xlsxReader;
    }

    @Override
    public AbstractReader readBySax(String sheetName, DataReadHandler dataReadHandler) {
        this.mySheet = this.myExcel.getSheetByName(sheetName);
        this.dataReadHandler = dataReadHandler;
        this.startProcess(this.sheetMap.containsKey(sheetName) ? sheetName : this.firstSheetName);
        return this;
    }

    public void startRow(int rowNum) {
        this.rowNum = rowNum;
    }

    public void endRow(int rowNum) {
        super.processRow(this.myExcel, this.titles, this.keys, this.dataReadHandler, this.mySheet, rowNum, this.rowCells);
        this.rowCells.clear();
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        if (cellReference == null) {
            return;
        }
        this.colNum = new CellReference(cellReference).getCol();
        this.addToRowCells(this.rowNum, this.colNum, formattedValue);
    }

    private void startProcess(String sheetName) {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.sheetMap.get(sheetName));
        InputSource sheetSource = new InputSource(stream);
        XMLReader sheetParser = XMLHelper.newXMLReader();
        Comments comments = this.sheetCommentsMap.get(sheetName);
        DataFormatter df = new DataFormatter();
        XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)this.styles, comments, this.strings, (XSSFSheetXMLHandler.SheetContentsHandler)this, (org.apache.poi.ss.usermodel.DataFormatter)df, false);
        sheetParser.setContentHandler((ContentHandler)handler);
        sheetParser.parse(sheetSource);
    }

    private void addToRowCells(int row, int column, Object value) {
        while (column > this.rowCells.size()) {
            this.rowCells.add(null);
        }
        this.rowCells.add(column, value);
    }

    public class DataFormatter
    extends org.apache.poi.ss.usermodel.DataFormatter {
        public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
            MyColumn myColumn;
            String key;
            if (org.apache.poi.ss.usermodel.DateUtil.isADateFormat((int)formatIndex, (String)formatString) && org.apache.poi.ss.usermodel.DateUtil.isValidExcelDate((double)value) && StrUtil.isNotBlank((CharSequence)(key = XlsxReader.this.keys.get(XlsxReader.this.colNum + 1))) && (myColumn = XlsxReader.this.mySheet.getFieldColMap().get(key)) != null && StrUtil.isNotBlank((CharSequence)myColumn.getDateFormat())) {
                Date date = org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)value, (boolean)use1904Windowing);
                return DateUtil.format((Date)date, (String)myColumn.getDateFormat());
            }
            return super.formatRawCellContents(value, formatIndex, formatString, use1904Windowing);
        }
    }
}

