/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.reader;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.exceptions.POIException;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.MyWorkbook;
import cn.renlm.plugins.MyExcel.handler.DataReadHandler;
import cn.renlm.plugins.MyExcel.reader.AbstractReader;
import cn.renlm.plugins.MyExcel.util.MergeUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.eventusermodel.EventWorkbookBuilder;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.MissingRecordAwareHSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;

public class XlsReader
extends AbstractReader
implements HSSFListener {
    private MySheet mySheet;
    private DataReadHandler dataReadHandler;
    private FormatTrackingHSSFListener formatListener;
    private EventWorkbookBuilder.SheetRecordCollectingListener workbookBuildingListener;
    private SSTRecord sstRecord;
    private HSSFWorkbook stubWorkbook;
    private final List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private Integer rSheetIndex = -1;
    private Integer sheetIndex = -1;
    final List<List<String>> titles = new ArrayList<List<String>>();
    final List<String> keys = new ArrayList<String>();
    private List<Object> rowCells = new ArrayList<Object>();

    public XlsReader(MyWorkbook myExcel, InputStream in) {
        super(myExcel, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractReader read(String sheetName, DataReadHandler dataReadHandler) {
        XlsReader xlsReader;
        block9: {
            this.titles.clear();
            this.keys.clear();
            this.rowCells.clear();
            this.mySheet = this.myExcel.getSheetByName(sheetName);
            this.dataReadHandler = dataReadHandler;
            ByteArrayInputStream in = new ByteArrayInputStream(this.bytes);
            try {
                ExcelReader reader = ExcelUtil.getReader((InputStream)in, (int)0);
                List sheetNames = reader.getSheetNames();
                if (sheetNames.contains(sheetName)) {
                    reader.setSheet(sheetName);
                } else {
                    reader.setSheet(0);
                }
                AtomicInteger rowIndex = new AtomicInteger(0);
                reader.read((cell, value) -> {
                    int rIndex = cell.getRowIndex();
                    int cIndex = cell.getColumnIndex();
                    if (!NumberUtil.equals((long)rowIndex.get(), (long)rIndex)) {
                        super.processRow(this.myExcel, this.titles, this.keys, dataReadHandler, this.mySheet, rowIndex.getAndIncrement(), this.rowCells);
                        this.rowCells.clear();
                    }
                    if (value == null) {
                        this.addToRowCells(rIndex, cIndex, value);
                    } else {
                        Sheet sh = cell.getSheet();
                        Cell _cell = MergeUtil.findFirstCellOfUnitRegion(sh, rIndex, cIndex);
                        Object _value = CellUtil.getCellValue((Cell)_cell);
                        this.addToRowCells(rIndex, cIndex, _value);
                    }
                });
                if (CollUtil.isNotEmpty(this.rowCells)) {
                    super.processRow(this.myExcel, this.titles, this.keys, dataReadHandler, this.mySheet, rowIndex.getAndIncrement(), this.rowCells);
                    this.rowCells.clear();
                }
                xlsReader = this;
                if (Collections.singletonList(in).get(0) == null) break block9;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(in).get(0) != null) {
                    ((InputStream)in).close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        return xlsReader;
    }

    @Override
    public AbstractReader readBySax(String sheetName, DataReadHandler dataReadHandler) {
        this.mySheet = this.myExcel.getSheetByName(sheetName);
        this.dataReadHandler = dataReadHandler;
        this.startProcess(-1);
        if (this.rSheetIndex == -1) {
            this.startProcess(0);
        }
        return this;
    }

    public void processRecord(Record record) {
        if (this.rSheetIndex > -1 && this.sheetIndex > this.rSheetIndex) {
            return;
        }
        Object value = null;
        short sid = record.getSid();
        switch (sid) {
            case 133: {
                BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                this.boundSheetRecords.add(boundSheetRecord);
                String currentSheetName = boundSheetRecord.getSheetname();
                if (this.rSheetIndex >= 0 || !StrUtil.equals((CharSequence)this.mySheet.getName(), (CharSequence)currentSheetName)) break;
                this.rSheetIndex = this.boundSheetRecords.size() - 1;
                break;
            }
            case 2057: {
                BOFRecord bofRecord = (BOFRecord)record;
                if (bofRecord.getType() != 16) break;
                Integer n = this.sheetIndex;
                Integer n2 = this.sheetIndex = Integer.valueOf(this.sheetIndex + 1);
                if (this.workbookBuildingListener == null || this.stubWorkbook != null) break;
                this.stubWorkbook = this.workbookBuildingListener.getStubHSSFWorkbook();
                break;
            }
            case 252: {
                this.sstRecord = (SSTRecord)record;
                break;
            }
        }
        if (NumberUtil.equals((long)this.rSheetIndex.intValue(), (long)this.sheetIndex.intValue())) {
            switch (sid) {
                case 517: {
                    BoolErrRecord berec = (BoolErrRecord)record;
                    value = berec.getBooleanValue();
                    this.addToRowCells(berec.getRow(), berec.getColumn(), value);
                    break;
                }
                case 6: {
                    FormulaRecord formulaRec = (FormulaRecord)record;
                    value = HSSFFormulaParser.toFormulaString((HSSFWorkbook)this.stubWorkbook, (Ptg[])formulaRec.getParsedExpression());
                    this.addToRowCells(formulaRec.getRow(), formulaRec.getColumn(), value);
                    break;
                }
                case 516: {
                    LabelRecord lrec = (LabelRecord)record;
                    this.addToRowCells(lrec.getRow(), lrec.getColumn(), lrec.getValue());
                    break;
                }
                case 253: {
                    LabelSSTRecord lsrec = (LabelSSTRecord)record;
                    value = this.sstRecord == null ? null : this.sstRecord.getString(lsrec.getSSTIndex()).toString();
                    this.addToRowCells(lsrec.getRow(), lsrec.getColumn(), value);
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    value = ExcelSaxUtil.getNumberOrDateValue((CellValueRecordInterface)numrec, (double)numrec.getValue(), (FormatTrackingHSSFListener)this.formatListener);
                    this.addToRowCells(numrec.getRow(), numrec.getColumn(), value);
                    break;
                }
            }
            if (record instanceof LastCellOfRowDummyRecord) {
                LastCellOfRowDummyRecord lastCell = (LastCellOfRowDummyRecord)record;
                super.processRow(this.myExcel, this.titles, this.keys, this.dataReadHandler, this.mySheet, lastCell.getRow(), this.rowCells);
                this.rowCells.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcess(Integer rSheetIndex) {
        this.sstRecord = null;
        this.stubWorkbook = null;
        this.boundSheetRecords.clear();
        this.rSheetIndex = rSheetIndex;
        this.sheetIndex = -1;
        this.titles.clear();
        this.keys.clear();
        this.rowCells.clear();
        ByteArrayInputStream in = new ByteArrayInputStream(this.bytes);
        try {
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
            try {
                this.formatListener = new FormatTrackingHSSFListener((HSSFListener)new MissingRecordAwareHSSFListener((HSSFListener)this));
                HSSFRequest request = new HSSFRequest();
                this.workbookBuildingListener = new EventWorkbookBuilder.SheetRecordCollectingListener((HSSFListener)this.formatListener);
                request.addListenerForAllRecords((HSSFListener)this.workbookBuildingListener);
                HSSFEventFactory factory = new HSSFEventFactory();
                try {
                    factory.processWorkbookEvents(request, fs);
                }
                catch (IOException e) {
                    throw new POIException((Throwable)e);
                }
                finally {
                    IoUtil.close((Closeable)fs);
                }
            }
            finally {
                if (Collections.singletonList(fs).get(0) != null) {
                    fs.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                ((InputStream)in).close();
            }
        }
    }

    private void addToRowCells(int row, int column, Object value) {
        while (column > this.rowCells.size()) {
            this.rowCells.add(null);
        }
        this.rowCells.add(column, value);
    }
}

