/*
 * Copyright (c) 2020 Renlm
 * MyGenerator is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 	http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
package cn.renlm.plugins;

import java.io.Serializable;
import java.util.List;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;

import lombok.Data;

/**
 * 代码生成配置
 * 
 * @author RenLiMing(任黎明)
 *
 */
@Data
@XStreamAlias("config")
public class MyGeneratorConf {

	@XStreamAlias("template")
	private _TemplateConfig templateConfig;

	@XStreamAlias("package")
	private _PackageConfig packageConfig;

	@XStreamAlias("strategy")
	private _StrategyConfig strategyConfig;

	/**
	 * 模板配置
	 */
	@Data
	public static final class _TemplateConfig implements Serializable {

		private static final long serialVersionUID = 1L;

		/**
		 * 是否生成Controller（默认否）
		 */
		@XStreamAlias("controller")
		private boolean enableController;

	}

	/**
	 * 包配置
	 */
	@Data
	public static final class _PackageConfig implements Serializable {

		private static final long serialVersionUID = 1L;

		/**
		 * Controller包名
		 */
		private String controller = "controller";

		/**
		 * Service Impl包名
		 */
		private String serviceImpl = "service.impl";

		/**
		 * Service包名
		 */
		private String service = "service";

		/**
		 * Entity包名
		 */
		private String entity = "entity";

		/**
		 * Mapper包名
		 */
		private String mapper = "dao";

		/**
		 * Mapper XML包名
		 */
		private String xml = "mapper";

	}

	/**
	 * 策略配置
	 */
	@Data
	public static final class _StrategyConfig implements Serializable {

		private static final long serialVersionUID = 1L;

		private _Entity entity;

	}

	/**
	 * 实体配置
	 */
	@Data
	public static final class _Entity implements Serializable {

		private static final long serialVersionUID = 1L;

		/**
		 * 父类（全路径名称）
		 */
		private String superClass;

		/**
		 * 禁用生成serialVersionUID
		 */
		private boolean disableSerialVersionUID;

		/**
		 * 父类字段集
		 */
		private _SuperEntityColumns superEntityColumns;

	}

	@Data
	public static final class _SuperEntityColumns implements Serializable {

		private static final long serialVersionUID = 1L;

		@XStreamImplicit(itemFieldName = "column")
		private List<_Text> superEntityColumns;

	}

	@Data
	@XStreamConverter(value = ToAttributedValueConverter.class, strings = { "text" })
	public class _Text implements Serializable {

		private static final long serialVersionUID = 1L;

		private String text;

	}

}
