/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyResponse;

import cn.renlm.plugins.MyResponse.StatusCode;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String message;
    private T data;

    public static <R> Result<R> of(StatusCode status) {
        return new Result<Object>(status.getValue(), status.getReasonPhrase(), null);
    }

    public static <R> Result<R> of(StatusCode status, String message) {
        Result<R> result = Result.of(status);
        return result.setMessage(message);
    }

    public static <R> Result<R> success() {
        return Result.of(StatusCode.OK);
    }

    public static <R> Result<R> success(R data) {
        Result<R> result = Result.success();
        return result.setData(data);
    }

    public static <R> Result<R> error() {
        return Result.of(StatusCode.INTERNAL_SERVER_ERROR);
    }

    public static <R> Result<R> error(String message) {
        return Result.of(StatusCode.INTERNAL_SERVER_ERROR, message);
    }

    public boolean isSuccess() {
        return this.statusCode == StatusCode.OK.getValue();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public Result<T> setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Result<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public Result<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatusCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(statusCode=" + this.getStatusCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public Result() {
    }

    public Result(int statusCode, String message, T data) {
        this.statusCode = statusCode;
        this.message = message;
        this.data = data;
    }
}

