/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.MyExcel.config.MyColumn;
import cn.renlm.plugins.MyExcel.config.column.Dict;
import cn.renlm.plugins.MyExcel.entity.CellUnit;
import cn.renlm.plugins.MyExcel.util.StyleUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DataWriterHandler {
    private final SXSSFWorkbook wb;
    private final SXSSFSheet createSheet;
    private final int dataRowStart;
    private final List<Map<String, CellUnit>> fieldTitles;

    public DataWriterHandler(SXSSFWorkbook wb, SXSSFSheet createSheet, int dataRowStart, List<Map<String, CellUnit>> fieldTitles) {
        this.wb = wb;
        this.createSheet = createSheet;
        this.dataRowStart = dataRowStart;
        this.fieldTitles = fieldTitles;
    }

    public String getSheetName() {
        return this.createSheet.getSheetName();
    }

    public void write(Object object) {
        ArrayList<Object> datas = new ArrayList<Object>();
        Map fields = (Map)CollUtil.getFirst(this.fieldTitles);
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            CollUtil.addAll(datas, (Object[])((Object[])object));
        } else if (ClassUtil.isAssignable(Iterable.class, clazz)) {
            CollUtil.addAll(datas, (Object)((Iterable)object));
        } else {
            datas.add(object);
        }
        for (Object e : datas) {
            Map data = BeanUtil.beanToMap(e, (String[])new String[0]);
            int colNum = 0;
            int rowNum = this.createSheet.getLastRowNum() + 1;
            SXSSFRow row = this.createSheet.createRow(rowNum);
            for (Map.Entry entry : fields.entrySet()) {
                String field = (String)entry.getKey();
                CellUnit cellUnit = (CellUnit)entry.getValue();
                MyColumn col = cellUnit.getColumn();
                Cell cell = row.createCell(colNum++);
                Object value = data.get(field);
                if (value == null) {
                    data.put(field, "");
                } else {
                    String valStr;
                    if (data.get(field) != null && StrUtil.isNotBlank((CharSequence)col.getDateFormat()) && data.get(field) instanceof Date) {
                        data.put(field, DateUtil.format((Date)((Date)data.get(field)), (String)col.getDateFormat()));
                    }
                    if (StrUtil.isNotBlank((CharSequence)col.getNumberFormat())) {
                        data.put(field, NumberUtil.decimalFormat((String)col.getNumberFormat(), data.get(field)));
                    }
                    if (col.getDict() != null) {
                        Dict.DictItem di;
                        valStr = data.get(field).toString();
                        if (col.getDict().getType() == Dict.DictType.value && (di = col.getDict().getKeyMap().get(valStr)) != null) {
                            data.put(field, di.getValue());
                        }
                    }
                    if (StrUtil.isNotBlank((CharSequence)col.getSuffix())) {
                        valStr = data.get(field).toString();
                        data.put(field, StrUtil.addSuffixIfNot((CharSequence)valStr, (CharSequence)col.getSuffix()));
                    }
                    if (StrUtil.isNotBlank((CharSequence)col.getPrefix())) {
                        valStr = data.get(field).toString();
                        data.put(field, StrUtil.addPrefixIfNot((CharSequence)valStr, (CharSequence)col.getPrefix()));
                    }
                }
                cell.setCellValue(ObjectUtil.toString(data.get(field)));
                cell.setCellStyle(cellUnit.getColumn().getCellStyle((Workbook)this.wb));
            }
            if (rowNum != this.dataRowStart && rowNum - this.dataRowStart != 25) continue;
            StyleUtil.autoSizeColumn(this.createSheet, this.fieldTitles);
        }
    }
}

