/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.handler;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.MyExcel.config.MyColumn;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.column.Dict;
import cn.renlm.plugins.MyExcel.entity.CheckResult;
import java.util.Date;
import java.util.Map;

@FunctionalInterface
public interface DataReadHandler {
    public void handle(Map<String, Object> var1, CheckResult var2);

    default public CheckResult readConvert(MySheet sheet, long rowIndex, Map<String, Object> data) {
        CheckResult checkResult = new CheckResult().setRowIndex(rowIndex).setProcess(true);
        Map<String, MyColumn> fieldColMap = sheet.getFieldColMap();
        for (Map.Entry<String, MyColumn> entry : fieldColMap.entrySet()) {
            String message;
            String valStr;
            String field = entry.getKey();
            MyColumn col = entry.getValue();
            if (StrUtil.isBlankIfStr((Object)data.get(field))) {
                data.put(field, null);
            }
            if (data.get(field) != null && StrUtil.isNotBlank((CharSequence)col.getPrefix()) && data.get(field).toString().startsWith(col.getPrefix())) {
                valStr = data.get(field).toString();
                data.put(field, StrUtil.removePrefix((CharSequence)valStr, (CharSequence)col.getPrefix()));
            }
            if (data.get(field) != null && StrUtil.isNotBlank((CharSequence)col.getSuffix()) && data.get(field).toString().endsWith(col.getSuffix())) {
                valStr = data.get(field).toString();
                data.put(field, StrUtil.removeSuffix((CharSequence)valStr, (CharSequence)col.getSuffix()));
            }
            if (data.get(field) != null && col.getDict() != null) {
                Dict.DictItem di;
                valStr = data.get(field).toString();
                if (col.getDict().getType() == Dict.DictType.key) {
                    if (BooleanUtil.isTrue((Boolean)col.getDict().isForceCheck()) && StrUtil.isNotBlank((CharSequence)valStr) && !col.getDict().getKeyMap().containsKey(valStr)) {
                        message = StrUtil.format((CharSequence)"{} / \u7b2c{}\u884c\uff0c{}\uff0c\u5fc5\u987b\u4e3a\u4e0b\u62c9\u9650\u5b9a\u503c", (Object[])new Object[]{sheet.getName(), rowIndex, col.getTitle().getText()});
                        checkResult.getErrors().add(message);
                        continue;
                    }
                    di = col.getDict().getKeyMap().get(valStr);
                    if (di != null && StrUtil.isNotBlank((CharSequence)col.getDict().getConvertToField())) {
                        data.put(col.getDict().getConvertToField(), di.getValue());
                    }
                } else if (col.getDict().getType() == Dict.DictType.value) {
                    if (BooleanUtil.isTrue((Boolean)col.getDict().isForceCheck()) && StrUtil.isNotBlank((CharSequence)valStr) && !col.getDict().getValMap().containsKey(valStr)) {
                        message = StrUtil.format((CharSequence)"{} / \u7b2c{}\u884c\uff0c{}\uff0c\u5fc5\u987b\u4e3a\u4e0b\u62c9\u9650\u5b9a\u503c", (Object[])new Object[]{sheet.getName(), rowIndex, col.getTitle().getText()});
                        checkResult.getErrors().add(message);
                        continue;
                    }
                    di = col.getDict().getValMap().get(valStr);
                    if (di != null) {
                        valStr = di.getKey();
                        data.put(field, valStr);
                    }
                }
            }
            if (data.get(field) != null && StrUtil.isNotBlank((CharSequence)col.getNumberFormat())) {
                valStr = data.get(field).toString();
                data.put(field, NumberUtil.parseNumber((String)valStr));
            }
            if (data.get(field) != null && StrUtil.isNotBlank((CharSequence)col.getDateFormat()) && !(data.get(field) instanceof Date)) {
                try {
                    valStr = data.get(field).toString();
                    data.put(field, DateUtil.parse((CharSequence)valStr, (String)col.getDateFormat()));
                }
                catch (Exception e) {
                    data.put(field, null);
                    message = StrUtil.format((CharSequence)"{} / \u7b2c{}\u884c\uff0c\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u9650\u5b9a{}", (Object[])new Object[]{sheet.getName(), rowIndex, col.getTitle().getText(), col.getDateFormat()});
                    checkResult.getErrors().add(message);
                }
            }
            if (!col.isNotNull() || data.get(field) != null && !StrUtil.isBlankIfStr((Object)data.get(field))) continue;
            String message2 = StrUtil.format((CharSequence)"{} / \u7b2c{}\u884c\uff0c{}\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{sheet.getName(), rowIndex, col.getTitle().getText()});
            checkResult.getErrors().add(message2);
        }
        return checkResult;
    }
}

