/*
 * Copyright (c) 2020 Renlm
 * MyUtil is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 	http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
package cn.renlm.plugins.MyResponse;

import lombok.Getter;

/**
 * 响应状态码
 * 
 * @author Renlm
 *
 */
public enum StatusCode {

	// 200
	OK(200, "OK"),
	// 400
	BAD_REQUEST(400, "Bad Request"),
	// 401
	UNAUTHORIZED(401, "Unauthorized"),
	// 402
	PAYMENT_REQUIRED(402, "Payment Required"),
	// 403
	FORBIDDEN(403, "Forbidden"),
	// 404
	NOT_FOUND(404, "Not Found"),
	// 500
	INTERNAL_SERVER_ERROR(500, "Internal Server Error");

	@Getter
	private final int value;

	@Getter
	private final String reasonPhrase;

	StatusCode(int value, String reasonPhrase) {
		this.value = value;
		this.reasonPhrase = reasonPhrase;
	}

}
