/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MyMarkdownUtil {
    private static final String ARR_TAG = "[ ]";

    public static final String classToTable(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)ClassUtil.isSimpleTypeOrArray(clazz), (String)"clazz\u4e3a\u7b80\u5355\u503c\u7c7b\u578b\u6216\u7b80\u5355\u503c\u7c7b\u578b\u7684\u6570\u7ec4", (Object[])new Object[0]);
        StringBuffer sb = new StringBuffer();
        HashSet set = new HashSet();
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        MyMarkdownUtil.classToTableRecursion("", set, clazz, map);
        sb.append("|\u5b57\u6bb5").append("|\u7c7b\u578b").append("|\u6ce8\u91ca|");
        sb.append("\r\n");
        sb.append("|:-").append("|:-").append("|:-|");
        sb.append("\r\n");
        map.forEach((name, field) -> {
            sb.append("|").append((String)name);
            sb.append("|").append(field.getType().getSimpleName());
            sb.append("|").append("-");
            sb.append("|");
            sb.append("\r\n");
        });
        return sb.toString();
    }

    private static final void classToTableRecursion(String prefix, Set<Class<?>> set, Class<?> clazz, Map<String, Field> map) {
        Field[] fields;
        if (set.contains(clazz)) {
            return;
        }
        set.add(clazz);
        for (Field field : fields = ReflectUtil.getFields(clazz)) {
            String fieldName = StrUtil.isNotBlank((CharSequence)prefix) ? prefix + "." + field.getName() : field.getName();
            Class<?> fieldType = field.getType();
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || map.containsKey(fieldName)) continue;
            if (ClassUtil.isSimpleValueType(fieldType)) {
                map.put(fieldName, field);
                continue;
            }
            if (clazz.isArray()) {
                map.put(fieldName, field);
                if (ClassUtil.isSimpleTypeOrArray(clazz.getComponentType())) continue;
                MyMarkdownUtil.classToTableRecursion(fieldName + ARR_TAG, set, fieldType.getComponentType(), map);
                continue;
            }
            if (ClassUtil.isAssignable(fieldType, Set.class) || ClassUtil.isAssignable(fieldType, List.class)) {
                ParameterizedType pt;
                map.put(fieldName, field);
                Type fgt = field.getGenericType();
                if (fgt == null || !(fgt instanceof ParameterizedType) || ArrayUtil.isEmpty((Object[])(pt = (ParameterizedType)fgt).getActualTypeArguments())) continue;
                Class clz = (Class)pt.getActualTypeArguments()[0];
                MyMarkdownUtil.classToTableRecursion(fieldName + ARR_TAG, set, clz, map);
                continue;
            }
            map.put(fieldName, field);
            MyMarkdownUtil.classToTableRecursion(fieldName, set, fieldType, map);
        }
    }

    private MyMarkdownUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

