/*
 * Copyright (c) 2020 Renlm
 * MyUtil is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 * 	http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
package cn.renlm.plugins.Common;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 枚举对象
 * 
 * @author Renlm
 *
 * @param <T>
 */
public class StrToEnum<T extends Enum<T> & StrToEnum.StrValue> {

	public static interface StrValue {
		String value();
	}

	private final Map<String, T> map;

	public StrToEnum(final T[] enumValues) {
		map = new LinkedHashMap<>();
		for (T enumValue : enumValues) {
			map.put(enumValue.value(), enumValue);
		}
	}

	public T valueToEnum(final String str) {
		return this.map.get(str);
	}
}