/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.ConstVal;
import cn.renlm.plugins.MyUtil.MyXStreamUtil;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.TemplateType;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.querys.PostgreSqlQuery;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MyGeneratorUtil {
    private static final String excelXmlName = "excel.xml";
    private static final String mapperOutputDir = ConstVal.resourcesDir + "/mapper";
    private static final String otherOutputDir = ConstVal.resourcesDir + "/excel";
    private static final String excelXmlTemplatePath = "config/Excel.xml.ftl";
    private static final String serviceImplTemplatePath = "config/ServiceImpl.java";

    public static final void run(String xml) {
        GeneratorConfig conf = MyXStreamUtil.read(GeneratorConfig.class, xml);
        DataSourceConfig dsc = new DataSourceConfig.Builder(conf.url, conf.username, conf.password).build();
        DbType dbType = dsc.getDbType();
        if (dbType == DbType.POSTGRE_SQL) {
            ReflectUtil.setFieldValue((Object)dsc, (String)"dbQuery", (Object)new PostgreSqlQuery(){

                public String tableFieldsSql() {
                    return "SELECT A.attname AS name,format_type (A.atttypid,A.atttypmod) AS type,col_description (A.attrelid,A.attnum) AS comment,\n(CASE WHEN (SELECT COUNT (*) FROM pg_constraint AS PC WHERE PC.conrelid = C.oid AND A.attnum = PC.conkey[1] AND PC.contype = 'p') > 0 THEN 'PRI' ELSE '' END) AS key \nFROM pg_class AS C,pg_attribute AS A WHERE A.attrelid='\"%s\"'::regclass AND A.attrelid= C.oid AND A.attnum> 0 AND NOT A.attisdropped ORDER  BY A.attnum";
                }
            });
        }
        conf.modules.forEach(module -> ((GeneratorModule)module).tables.forEach(table -> MyGeneratorUtil.create(conf, dsc, ((GeneratorModule)module).pkg, ((GeneratorModule)module).name, table)));
    }

    private static final void create(GeneratorConfig conf, DataSourceConfig dsc, String pkg, String moduleName, final GeneratorTable table) {
        AutoGenerator autoGenerator = new AutoGenerator(dsc);
        autoGenerator.injection(MyGeneratorUtil.injectionConfig(conf));
        autoGenerator.template(MyGeneratorUtil.templateConfig());
        autoGenerator.strategy(MyGeneratorUtil.strategyConfig(table));
        autoGenerator.packageInfo(MyGeneratorUtil.packageConfig(pkg, moduleName));
        autoGenerator.global(MyGeneratorUtil.globalConfig(table));
        autoGenerator.execute((AbstractTemplateEngine)new FreemarkerTemplateEngine(){

            protected void outputEntity(@NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
                GlobalConfig globalConfig = this.getConfigBuilder().getGlobalConfig();
                boolean fileOverride = globalConfig.isFileOverride();
                ReflectUtil.setFieldValue((Object)globalConfig, (String)"fileOverride", (Object)(table.coverEntity ? table.coverEntity : fileOverride));
                super.outputEntity(tableInfo, objectMap);
                ReflectUtil.setFieldValue((Object)globalConfig, (String)"fileOverride", (Object)fileOverride);
            }

            protected void outputCustomFile(@NotNull Map<String, String> customFile, @NotNull TableInfo tableInfo, @NotNull Map<String, Object> objectMap) {
                if (table.configExcel) {
                    String entityName = tableInfo.getEntityName();
                    String otherPath = this.getPathInfo(OutputFile.other);
                    customFile.forEach((key, value) -> {
                        String fileName = otherPath + File.separator + entityName + "." + key;
                        this.outputFile(new File(fileName), objectMap, (String)value);
                    });
                }
            }
        });
    }

    private static final InjectionConfig injectionConfig(GeneratorConfig conf) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nameOfDS", DS.class.getName());
        map.put("dsName", conf.dsName);
        HashMap<String, String> customFile = new HashMap<String, String>();
        customFile.put(excelXmlName, excelXmlTemplatePath);
        return new InjectionConfig.Builder().customMap(map).customFile(customFile).build();
    }

    private static final TemplateConfig templateConfig() {
        return new TemplateConfig.Builder().serviceImpl(serviceImplTemplatePath).disable(new TemplateType[]{TemplateType.CONTROLLER}).build();
    }

    private static final StrategyConfig strategyConfig(GeneratorTable table) {
        return new StrategyConfig.Builder().addInclude(new String[]{table.name}).entityBuilder().idType(StrUtil.isBlank((CharSequence)table.idType) ? IdType.AUTO : IdType.valueOf((String)table.idType)).enableTableFieldAnnotation().enableLombok().enableChainModel().naming(NamingStrategy.underline_to_camel).columnNaming(NamingStrategy.underline_to_camel).build();
    }

    private static final PackageConfig packageConfig(String pkg, String moduleName) {
        HashMap<OutputFile, String> pathInfo = new HashMap<OutputFile, String>();
        pathInfo.put(OutputFile.mapperXml, mapperOutputDir + "/" + moduleName + "/");
        pathInfo.put(OutputFile.other, otherOutputDir + "/" + moduleName + "/");
        return new PackageConfig.Builder().parent(pkg).moduleName(moduleName).pathInfo(pathInfo).build();
    }

    private static final GlobalConfig globalConfig(GeneratorTable table) {
        return new GlobalConfig.Builder().outputDir(ConstVal.javaDir).author(table.author).disableOpenDir().dateType(DateType.ONLY_DATE).build();
    }

    public static final class GeneratorTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String schema;
        @XStreamAsAttribute
        private String author;
        @XStreamAsAttribute
        private String name;
        @XStreamAsAttribute
        private String idType;
        @XStreamAsAttribute
        @XStreamAlias(value="entity")
        private boolean coverEntity;
        @XStreamAsAttribute
        @XStreamAlias(value="excel")
        private boolean configExcel;

        public String getSchema() {
            return this.schema;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getName() {
            return this.name;
        }

        public String getIdType() {
            return this.idType;
        }

        public boolean isCoverEntity() {
            return this.coverEntity;
        }

        public boolean isConfigExcel() {
            return this.configExcel;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIdType(String idType) {
            this.idType = idType;
        }

        public void setCoverEntity(boolean coverEntity) {
            this.coverEntity = coverEntity;
        }

        public void setConfigExcel(boolean configExcel) {
            this.configExcel = configExcel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorTable)) {
                return false;
            }
            GeneratorTable other = (GeneratorTable)o;
            if (this.isCoverEntity() != other.isCoverEntity()) {
                return false;
            }
            if (this.isConfigExcel() != other.isConfigExcel()) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$idType = this.getIdType();
            String other$idType = other.getIdType();
            return !(this$idType == null ? other$idType != null : !this$idType.equals(other$idType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCoverEntity() ? 79 : 97);
            result = result * 59 + (this.isConfigExcel() ? 79 : 97);
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorTable(schema=" + this.getSchema() + ", author=" + this.getAuthor() + ", name=" + this.getName() + ", idType=" + this.getIdType() + ", coverEntity=" + this.isCoverEntity() + ", configExcel=" + this.isConfigExcel() + ")";
        }
    }

    public static final class GeneratorModule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String name;
        @XStreamAsAttribute
        @XStreamAlias(value="package")
        private String pkg;
        @XStreamImplicit(itemFieldName="table")
        private List<GeneratorTable> tables;

        public String getName() {
            return this.name;
        }

        public String getPkg() {
            return this.pkg;
        }

        public List<GeneratorTable> getTables() {
            return this.tables;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public void setTables(List<GeneratorTable> tables) {
            this.tables = tables;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorModule)) {
                return false;
            }
            GeneratorModule other = (GeneratorModule)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            if (this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg)) {
                return false;
            }
            List<GeneratorTable> this$tables = this.getTables();
            List<GeneratorTable> other$tables = other.getTables();
            return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            List<GeneratorTable> $tables = this.getTables();
            result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorModule(name=" + this.getName() + ", pkg=" + this.getPkg() + ", tables=" + this.getTables() + ")";
        }
    }

    @XStreamAlias(value="generator")
    public static final class GeneratorConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String dsName;
        private String url;
        private String username;
        private String password;
        @XStreamImplicit(itemFieldName="module")
        private List<GeneratorModule> modules;

        public String getDsName() {
            return this.dsName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public List<GeneratorModule> getModules() {
            return this.modules;
        }

        public void setDsName(String dsName) {
            this.dsName = dsName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setModules(List<GeneratorModule> modules) {
            this.modules = modules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorConfig)) {
                return false;
            }
            GeneratorConfig other = (GeneratorConfig)o;
            String this$dsName = this.getDsName();
            String other$dsName = other.getDsName();
            if (this$dsName == null ? other$dsName != null : !this$dsName.equals(other$dsName)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            List<GeneratorModule> this$modules = this.getModules();
            List<GeneratorModule> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dsName = this.getDsName();
            result = result * 59 + ($dsName == null ? 43 : $dsName.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            List<GeneratorModule> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorConfig(dsName=" + this.getDsName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", modules=" + this.getModules() + ")";
        }
    }
}

