/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.ConstVal;
import cn.renlm.plugins.MyExcel.config.MyColumn;
import cn.renlm.plugins.MyExcel.config.column.Alias;
import cn.renlm.plugins.MyExcel.config.column.Title;
import cn.renlm.plugins.MyExcel.entity.CellUnit;
import cn.renlm.plugins.MyExcel.entity.CheckResult;
import cn.renlm.plugins.MyExcel.handler.DataReadHandler;
import cn.renlm.plugins.MyExcel.util.MergeUtil;
import cn.renlm.plugins.MyExcel.util.StyleUtil;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class MySheet
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private int start = 0;
    @XStreamAsAttribute
    private int freezes = 0;
    @XStreamImplicit(itemFieldName="column")
    private List<MyColumn> columns;
    private Map<String, MyColumn> fieldColMap;

    public int level() {
        return this.columns.stream().map(col -> col.getTitle()).mapToInt(title -> {
            if (StrUtil.isNotBlank((CharSequence)title.getSplit())) {
                return title.getText().split(title.getSplit()).length;
            }
            return 1;
        }).max().getAsInt();
    }

    public Map<String, String> keyFields() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (MyColumn col : this.columns) {
            if (col.isIgnore()) continue;
            Title title = col.getTitle();
            map.put(title.getText(), col.getField());
            if (StrUtil.isNotBlank((CharSequence)title.getSplit())) {
                map.put(title.getText().replace(title.getSplit(), ConstVal.NAME), col.getField());
            }
            if (CollUtil.isEmpty(col.getAliasList())) continue;
            for (Alias alias : col.getAliasList()) {
                if (StrUtil.isEmpty((CharSequence)alias.getText())) continue;
                map.put(alias.getText(), col.getField());
                if (!StrUtil.isNotBlank((CharSequence)title.getSplit())) continue;
                map.put(alias.getText().replace(title.getSplit(), ConstVal.NAME), col.getField());
            }
        }
        return map;
    }

    public List<String> generateKeys(List<List<String>> titles, DataReadHandler dataReadHandler) {
        ArrayList<String> keys = new ArrayList<String>();
        Map<String, String> keyFields = this.keyFields();
        CheckResult checkResult = new CheckResult().setRowIndex(this.start);
        int length = titles.stream().mapToInt(it -> it.size()).max().getAsInt();
        for (int i = 0; i < length; ++i) {
            ArrayList<String> appends = new ArrayList<String>();
            for (List<String> it2 : titles) {
                String str = (String)CollUtil.get(it2, (int)i);
                if (!StrUtil.isNotBlank((CharSequence)str) || appends.size() != 0 && str.equals(appends.get(appends.size() - 1))) continue;
                appends.add(str);
            }
            String key = CollUtil.join(appends, (CharSequence)ConstVal.NAME);
            if (keyFields.containsKey(key)) {
                keys.add(keyFields.get(key));
                continue;
            }
            keys.add("");
        }
        Map<String, MyColumn> fieldColMap = this.getFieldColMap();
        for (Map.Entry<String, MyColumn> entry : fieldColMap.entrySet()) {
            String field = entry.getKey();
            MyColumn col = entry.getValue();
            if (col.isIgnore() || col.isOptional() || keys.contains(field)) continue;
            String message = StrUtil.format((CharSequence)"{}\uff0c\u6a21\u677f\u9519\u8bef\uff0c\u7f3a\u5931\u5217", (Object[])new Object[]{col.getTitle().getText()});
            checkResult.getErrors().add(message);
        }
        if (checkResult.isError()) {
            dataReadHandler.handle(MapUtil.empty(), checkResult);
        }
        return keys;
    }

    public List<Map<String, CellUnit>> fieldTitles(SXSSFWorkbook wb, boolean isTemplate) {
        int level = this.level();
        ArrayList<Map<String, CellUnit>> titles = new ArrayList<Map<String, CellUnit>>();
        for (int i = 0; i < level; ++i) {
            LinkedHashMap<String, CellUnit> data = new LinkedHashMap<String, CellUnit>();
            titles.add(data);
            for (MyColumn col : this.columns) {
                if (col.isIgnore() || isTemplate && col.isOptional()) continue;
                CellUnit cellUnit = new CellUnit();
                cellUnit.setRowIndex(this.start + i);
                cellUnit.setColIndex(i);
                cellUnit.setColumn(col);
                data.put(col.getField(), cellUnit);
                if (StrUtil.isBlank((CharSequence)col.getTitle().getSplit())) {
                    short fontSize = level == 1 ? (short)10 : 11;
                    CellStyle cellStyle = StyleUtil.createCellStyleWithBorder((Workbook)wb, "SimSun", fontSize, true, col.getAlign());
                    cellUnit.setText(col.getTitle().getText());
                    cellUnit.setCellStyle(cellStyle);
                    continue;
                }
                String[] arr = col.getTitle().getText().split(col.getTitle().getSplit());
                short fontSize = i >= arr.length - 1 ? (short)10 : 11;
                HorizontalAlignment align = i >= arr.length - 1 ? col.getAlign() : HorizontalAlignment.CENTER;
                CellStyle cellStyle = StyleUtil.createCellStyleWithBorder((Workbook)wb, "SimSun", fontSize, true, align);
                cellUnit.setText(i >= arr.length ? arr[arr.length - 1] : arr[i]);
                cellUnit.setCellStyle(cellStyle);
            }
        }
        return titles;
    }

    public static final List<String> fillTitle(List<Object> rowList) {
        String lastTitle = null;
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : rowList) {
            if (obj == null) {
                list.add(lastTitle);
                continue;
            }
            String str = obj.toString().chars().filter(c -> !CharUtil.isBlankChar((int)c)).mapToObj(c -> CharUtil.toString((char)((char)c))).collect(Collectors.joining());
            if (StrUtil.isEmptyIfStr((Object)str)) {
                list.add("");
                continue;
            }
            lastTitle = str;
            list.add(lastTitle);
        }
        return list;
    }

    public Map<String, List<Integer[]>> writeSheetTitle(int start, SXSSFSheet sh, List<Map<String, CellUnit>> fieldTitles) {
        int currentRowIndex = start;
        LinkedHashMap<String, List<Integer[]>> rowColMap = new LinkedHashMap<String, List<Integer[]>>();
        for (Map<String, CellUnit> data : fieldTitles) {
            int currentColIndex = 0;
            SXSSFRow row = sh.createRow(currentRowIndex++);
            for (Map.Entry<String, CellUnit> entry : data.entrySet()) {
                Cell cell = row.createCell(currentColIndex++);
                cell.setCellValue(entry.getValue().getText());
                cell.setCellStyle(entry.getValue().getCellStyle());
                MergeUtil.pushTitleRowColMap(rowColMap, entry.getValue().getText(), new Integer[]{row.getRowNum(), cell.getColumnIndex()});
            }
        }
        return rowColMap;
    }

    public Map<String, MyColumn> getFieldColMap() {
        if (this.fieldColMap == null) {
            this.fieldColMap = new LinkedHashMap<String, MyColumn>();
            for (MyColumn col : this.columns) {
                this.fieldColMap.put(col.getField(), col);
            }
        }
        return this.fieldColMap;
    }

    public String getName() {
        return this.name;
    }

    public int getStart() {
        return this.start;
    }

    public int getFreezes() {
        return this.freezes;
    }

    public List<MyColumn> getColumns() {
        return this.columns;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setFreezes(int freezes) {
        this.freezes = freezes;
    }

    public void setColumns(List<MyColumn> columns) {
        this.columns = columns;
    }

    public void setFieldColMap(Map<String, MyColumn> fieldColMap) {
        this.fieldColMap = fieldColMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MySheet)) {
            return false;
        }
        MySheet other = (MySheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getFreezes() != other.getFreezes()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<MyColumn> this$columns = this.getColumns();
        List<MyColumn> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, MyColumn> this$fieldColMap = this.getFieldColMap();
        Map<String, MyColumn> other$fieldColMap = other.getFieldColMap();
        return !(this$fieldColMap == null ? other$fieldColMap != null : !((Object)this$fieldColMap).equals(other$fieldColMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MySheet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStart();
        result = result * 59 + this.getFreezes();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<MyColumn> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, MyColumn> $fieldColMap = this.getFieldColMap();
        result = result * 59 + ($fieldColMap == null ? 43 : ((Object)$fieldColMap).hashCode());
        return result;
    }

    public String toString() {
        return "MySheet(name=" + this.getName() + ", start=" + this.getStart() + ", freezes=" + this.getFreezes() + ", columns=" + this.getColumns() + ", fieldColMap=" + this.getFieldColMap() + ")";
    }
}

