/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import cn.renlm.plugins.MyCrawler.MySite;
import cn.renlm.plugins.MyCrawler.scheduler.MyDuplicateVerify;
import cn.renlm.plugins.MyCrawler.selenium.ChromeDownloader;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Spider;
import us.codecraft.webmagic.SpiderListener;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.processor.PageProcessor;

public class MySpider
extends Spider {
    private final MySite mySite;
    private final MyDuplicateVerify myDuplicateVerify;

    public MySpider(PageProcessor pageProcessor, MySite mySite, MyDuplicateVerify myDuplicateVerify) {
        super(pageProcessor);
        this.mySite = mySite;
        this.myDuplicateVerify = myDuplicateVerify;
    }

    public Spider addUrl(String ... urls) {
        if (ObjectUtil.isNotEmpty((Object)((Object)this.mySite)) && ObjectUtil.isNotEmpty((Object)this.myDuplicateVerify) && BooleanUtil.isTrue((Boolean)this.mySite.isForceUpdate())) {
            for (String url : urls) {
                this.myDuplicateVerify.cleanCache(new Request(url), (Task)this);
            }
        }
        super.addUrl(urls);
        return this;
    }

    public MySpider addRequest(Request ... requests) {
        if (ObjectUtil.isNotEmpty((Object)((Object)this.mySite)) && ObjectUtil.isNotEmpty((Object)this.myDuplicateVerify) && BooleanUtil.isTrue((Boolean)this.mySite.isForceUpdate())) {
            for (Request request : requests) {
                this.myDuplicateVerify.cleanCache(request, (Task)this);
            }
        }
        super.addRequest(requests);
        return this;
    }

    public MySpider onDownloaded(MySite site, final Consumer<Page> page) {
        if (ObjectUtil.isNotEmpty((Object)((Object)site)) && site.isEnableSelenuim()) {
            Setting chromeSetting = site.getChromeSetting();
            if (BooleanUtil.isTrue((Boolean)site.getHeadless())) {
                chromeSetting.set("headless", "true");
            }
            if (StrUtil.isNotBlank((CharSequence)site.getUserAgent())) {
                chromeSetting.set("userAgent", site.getUserAgent());
            }
            if (BooleanUtil.isTrue((Boolean)site.getScreenshot())) {
                chromeSetting.set("screenshot", "true");
            }
            ChromeDownloader downloader = new ChromeDownloader(chromeSetting){

                @Override
                public Page download(Request request, Task task) {
                    Page pager = super.download(request, task);
                    page.accept(pager);
                    return pager;
                }

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            this.setDownloader(downloader);
        } else {
            HttpClientDownloader downloader = new HttpClientDownloader(){

                public Page download(Request request, Task task) {
                    Page pager = super.download(request, task);
                    page.accept(pager);
                    return pager;
                }
            };
            this.setDownloader((Downloader)downloader);
        }
        return this;
    }

    public MySpider onSuccess(final Consumer<Request> request) {
        if (CollUtil.isEmpty((Collection)this.getSpiderListeners())) {
            this.setSpiderListeners(CollUtil.newArrayList((Object[])new SpiderListener[0]));
        }
        this.getSpiderListeners().add(new SpiderListener(){

            public void onSuccess(Request req) {
                request.accept(req);
            }

            public void onError(Request req) {
            }
        });
        return this;
    }

    public MySpider onError(final Consumer<Request> request) {
        if (CollUtil.isEmpty((Collection)this.getSpiderListeners())) {
            this.setSpiderListeners(CollUtil.newArrayList((Object[])new SpiderListener[0]));
        }
        this.getSpiderListeners().add(new SpiderListener(){

            public void onSuccess(Request req) {
            }

            public void onError(Request req) {
                request.accept(req);
            }
        });
        return this;
    }

    public MySite getMySite() {
        return this.mySite;
    }

    public MyDuplicateVerify getMyDuplicateVerify() {
        return this.myDuplicateVerify;
    }
}

