/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelFileUtil;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.MyWorkbook;
import cn.renlm.plugins.MyExcel.entity.CellUnit;
import cn.renlm.plugins.MyExcel.entity.CheckResult;
import cn.renlm.plugins.MyExcel.handler.DataReadHandler;
import cn.renlm.plugins.MyExcel.handler.DataWriterHandler;
import cn.renlm.plugins.MyExcel.util.MergeUtil;
import cn.renlm.plugins.MyExcel.util.StyleUtil;
import cn.renlm.plugins.MyUtil.MyXStreamUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class MyExcelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public static final Workbook createWorkbook(String config, boolean isTemplate, Consumer<DataWriterHandler> ... sheet) {
        SXSSFWorkbook workbook = null;
        MyWorkbook myExcel = MyXStreamUtil.read(MyWorkbook.class, config);
        if (StrUtil.isBlankIfStr((Object)myExcel.getRef())) {
            workbook = new SXSSFWorkbook();
        } else {
            InputStream in = ResourceUtil.getStream((String)myExcel.getRef());
            try {
                workbook = new SXSSFWorkbook(new XSSFWorkbook(in));
            }
            finally {
                if (Collections.singletonList(in).get(0) != null) {
                    in.close();
                }
            }
        }
        for (int i = 0; i < myExcel.getSheets().size(); ++i) {
            MySheet mySheet = myExcel.getSheets().get(i);
            int level = mySheet.level();
            SXSSFSheet createSheet = workbook.createSheet(mySheet.getName());
            workbook.setSheetOrder(mySheet.getName(), i);
            List<Map<String, CellUnit>> fieldTitles = mySheet.fieldTitles(workbook, isTemplate);
            Map<String, List<Integer[]>> rowColMap = mySheet.writeSheetTitle(mySheet.getStart(), createSheet, fieldTitles);
            MergeUtil.mergeComplexTitle((Sheet)createSheet, MergeUtil.findCellRangeAddress(mySheet.getStart(), level, rowColMap));
            createSheet.createFreezePane(mySheet.getFreezes(), mySheet.getStart() + level);
            StyleUtil.createTitleAnnotation((Workbook)workbook, (Sheet)createSheet, mySheet.getStart(), fieldTitles);
            StyleUtil.createDataValidation((Sheet)createSheet, mySheet.getStart(), fieldTitles);
            StyleUtil.autoSizeColumn(createSheet, fieldTitles);
            if (i >= sheet.length) continue;
            sheet[i].accept(new DataWriterHandler(workbook, createSheet, mySheet.getStart() + level, fieldTitles));
        }
        workbook.setActiveSheet(0);
        workbook.setSelectedTab(0);
        return workbook;
    }

    public static final int readBySax(String config, InputStream in, Integer sheetNo, DataReadHandler dataReadHandler) {
        return MyExcelUtil.readBySax(config, in, sheetNo, null, dataReadHandler);
    }

    public static final int readBySax(String config, InputStream in, String sheetName, DataReadHandler dataReadHandler) {
        return MyExcelUtil.readBySax(config, in, null, sheetName, dataReadHandler);
    }

    public static final int readBySax(String config, InputStream in, Integer sheetNo, String sheetName, final DataReadHandler dataReadHandler) {
        final MyWorkbook myExcel = MyXStreamUtil.read(MyWorkbook.class, config);
        final MySheet sheet = myExcel.getSheetByName(sheetName);
        final ArrayList titles = new ArrayList();
        final ArrayList keys = new ArrayList();
        final AtomicInteger rows = new AtomicInteger(0);
        if (ExcelFileUtil.isXls((InputStream)in) || ExcelFileUtil.isXlsx((InputStream)in)) {
            ExcelReaderBuilder builder = EasyExcel.read((InputStream)in, (ReadListener)new AnalysisEventListener<Map<Integer, Object>>(){

                public void invoke(Map<Integer, Object> data, AnalysisContext context) {
                    rows.incrementAndGet();
                    int rowIndex = context.readRowHolder().getRowIndex();
                    data = MapUtil.sort(data, (rowIndex1, rowIndex2) -> rowIndex1 - rowIndex2);
                    MyExcelUtil.processRow(myExcel, titles, keys, dataReadHandler, sheet, rowIndex, CollUtil.newArrayList(data.values()));
                }

                public void doAfterAllAnalysed(AnalysisContext context) {
                }
            });
            ((ExcelReaderSheetBuilder)builder.sheet(sheetNo, sheetName).headRowNumber(Integer.valueOf(0))).doRead();
        } else {
            CsvReader reader = CsvUtil.getReader();
            reader.read((Reader)IoUtil.getReader((InputStream)in, (Charset)Charset.forName(myExcel.getCsvCharset())), csvRow -> {
                rows.incrementAndGet();
                long rowIndex = csvRow.getOriginalLineNumber() - 1L;
                ArrayList<Object> rowList = new ArrayList<Object>(csvRow.getRawList());
                MyExcelUtil.processRow(myExcel, titles, keys, dataReadHandler, sheet, rowIndex, rowList);
            });
        }
        return rows.get();
    }

    private static final void processRow(MyWorkbook myExcel, List<List<String>> titles, List<String> keys, DataReadHandler dataReadHandler, MySheet sheet, long rowIndex, List<Object> rowList) {
        int sheetLevel = sheet.level();
        long level = rowIndex - (long)sheet.getStart() + 1L;
        if (level >= 1L) {
            if (level <= (long)sheetLevel) {
                titles.add(MySheet.fillTitle(rowList));
                if (level == (long)sheetLevel) {
                    keys.addAll(sheet.generateKeys(titles, dataReadHandler));
                }
            } else {
                Map data = CollUtil.zip(keys, rowList);
                data.remove("");
                CheckResult checkResult = dataReadHandler.readConvert(sheet, rowIndex, data);
                dataReadHandler.handle(data, checkResult);
            }
        }
    }

    private MyExcelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

