/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.selenium;

import cn.hutool.setting.Setting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChromeDriverPool {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverPool.class);
    private static final int STAT_RUNNING = 1;
    private static final int STAT_CLODED = 2;
    private AtomicInteger stat = new AtomicInteger(1);
    private List<WebDriver> webDriverList = Collections.synchronizedList(new ArrayList());
    private BlockingDeque<WebDriver> innerQueue = new LinkedBlockingDeque<WebDriver>();
    private final Setting chromeSetting;
    private final int capacity;
    private WebDriver mDriver = null;

    public ChromeDriverPool(Setting chromeSetting, int capacity) {
        this.chromeSetting = chromeSetting;
        this.capacity = capacity;
    }

    public void configure() throws IOException {
        String driverPath = this.chromeSetting.getStr((Object)"driverPath");
        String windowSize = this.chromeSetting.getStr("windowSize", "1415,1000");
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(true);
        options.addArguments(new String[]{"disable-infobars"});
        options.addArguments(new String[]{"--no-sandbox"});
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--disable-dev-shm-usage"});
        options.addArguments(new String[]{"--window-size=" + windowSize});
        System.setProperty("webdriver.chrome.driver", driverPath);
        options.setHeadless(true);
        this.mDriver = new ChromeDriver(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver get() throws InterruptedException {
        this.checkRunning();
        WebDriver poll = this.innerQueue.poll();
        if (poll != null) {
            return poll;
        }
        if (this.webDriverList.size() < this.capacity) {
            List<WebDriver> list = this.webDriverList;
            synchronized (list) {
                if (this.webDriverList.size() < this.capacity) {
                    try {
                        this.configure();
                        this.innerQueue.add(this.mDriver);
                        this.webDriverList.add(this.mDriver);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.innerQueue.take();
    }

    public void returnToPool(WebDriver webDriver) {
        this.checkRunning();
        this.innerQueue.add(webDriver);
    }

    protected void checkRunning() {
        if (!this.stat.compareAndSet(1, 1)) {
            throw new IllegalStateException("Already closed!");
        }
    }

    public void closeAll() {
        boolean b = this.stat.compareAndSet(1, 2);
        if (!b) {
            throw new IllegalStateException("Already closed!");
        }
        for (WebDriver webDriver : this.webDriverList) {
            log.info("Quit webDriver" + webDriver);
            webDriver.quit();
            Object var3_3 = null;
        }
    }
}

