/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.selenium;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.setting.Setting;
import cn.renlm.plugins.MyCrawler.selenium.ChromeDriverPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;

public class ChromeDownloader
implements Downloader,
Closeable {
    private volatile ChromeDriverPool webDriverPool;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int sleepTime = 0;
    private int poolSize = 1;
    private Setting chromeSetting;

    public ChromeDownloader(Setting chromeSetting) {
        this.chromeSetting = chromeSetting;
        this.sleepTime = (Integer)ObjectUtil.defaultIfNull((Object)chromeSetting.getInt((Object)"sleepTime"), (Object)0);
        this.checkInit();
    }

    public Page download(Request request, Task task) {
        WebDriver webDriver;
        this.checkInit();
        try {
            webDriver = this.webDriverPool.get();
        }
        catch (InterruptedException e) {
            this.logger.warn("interrupted", (Throwable)e);
            return null;
        }
        this.logger.info("downloading page " + request.getUrl());
        webDriver.get(request.getUrl());
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        WebDriver.Options manage = webDriver.manage();
        Site site = task.getSite();
        if (site.getCookies() != null) {
            for (Map.Entry cookieEntry : site.getCookies().entrySet()) {
                Cookie cookie = new Cookie((String)cookieEntry.getKey(), (String)cookieEntry.getValue());
                manage.addCookie(cookie);
            }
        }
        WebElement webElement = webDriver.findElement(By.xpath((String)"/html"));
        String content = webElement.getAttribute("outerHTML");
        Page page = new Page();
        page.setRawText(content);
        page.setUrl((Selectable)new PlainText(request.getUrl()));
        page.setRequest(request);
        this.webDriverPool.returnToPool(webDriver);
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (this.webDriverPool == null) {
            ChromeDownloader chromeDownloader = this;
            synchronized (chromeDownloader) {
                this.webDriverPool = new ChromeDriverPool(this.chromeSetting, this.poolSize);
            }
        }
    }

    public void setThread(int thread) {
        this.poolSize = thread;
    }

    @Override
    public void close() throws IOException {
        this.webDriverPool.closeAll();
    }
}

