/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.scheduler;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.NumberUtil;
import cn.renlm.plugins.MyCrawler.PageUrlType;
import cn.renlm.plugins.MyCrawler.scheduler.MyDuplicateVerify;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.RedisPriorityScheduler;

public class MyRedisScheduler
extends RedisPriorityScheduler
implements MyDuplicateVerify {
    private static final String VERIFY_PREFIX = "verify_";

    public MyRedisScheduler(JedisPool jedisPool) {
        super(jedisPool);
    }

    private String getVerifyKey(Task task) {
        return VERIFY_PREFIX + task.getUUID();
    }

    @Override
    public boolean verifyDuplicate(Request request, Task task) {
        String url = request.getUrl();
        Integer pageUrlType = (Integer)request.getExtra("_PageUrlTypeExtra_");
        try (Jedis jedis = this.pool.getResource();){
            String cacheKey = Base64.encode((CharSequence)url);
            if (NumberUtil.equals((float)pageUrlType.intValue(), (float)PageUrlType.seed.value())) {
                boolean duplicate = jedis.exists(cacheKey);
                if (!duplicate) {
                    jedis.srem(this.getSetKey(task), new String[]{url});
                    jedis.setex(cacheKey, 75600, url);
                }
                boolean bl = duplicate;
                return bl;
            }
            boolean bl = jedis.sadd(this.getVerifyKey(task), new String[]{url}) == 0L;
            return bl;
        }
    }
}

