/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.renlm.plugins.MyCrawler.MySite;
import cn.renlm.plugins.MyCrawler.MySpider;
import cn.renlm.plugins.MyCrawler.data.MyProcessPage;
import cn.renlm.plugins.MyCrawler.data.MyProcessPipe;
import cn.renlm.plugins.MyCrawler.pipeline.MyPipeline;
import cn.renlm.plugins.MyCrawler.processor.MyPageProcessor;
import cn.renlm.plugins.MyCrawler.scheduler.MyDuplicateVerify;
import cn.renlm.plugins.MyCrawler.scheduler.MyQueueScheduler;
import cn.renlm.plugins.MyCrawler.scheduler.MyRedisScheduler;
import java.util.Collection;
import java.util.List;
import redis.clients.jedis.JedisPool;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.scheduler.Scheduler;

public final class MyCrawlerUtil {
    private static final String depthExtraKey = "_MyCrawlerDepthExtra_";

    public static final MySpider createSpider(MySite site, MyPageProcessor pageProcessor, MyPipeline ... pipelines) {
        MyQueueScheduler scheduler = new MyQueueScheduler();
        MySpider mySpider = new MySpider(MyCrawlerUtil.createPageProcessor(site, pageProcessor));
        mySpider.setScheduler((Scheduler)scheduler);
        for (MyPipeline pipeline : pipelines) {
            mySpider.addPipeline(MyCrawlerUtil.createPipeline(site, pipeline, scheduler));
        }
        return mySpider;
    }

    public static final MySpider createSpider(JedisPool pool, MySite site, MyPageProcessor pageProcessor, MyPipeline ... pipelines) {
        MyRedisScheduler scheduler = new MyRedisScheduler(pool);
        MySpider mySpider = new MySpider(MyCrawlerUtil.createPageProcessor(site, pageProcessor));
        mySpider.setScheduler((Scheduler)scheduler);
        for (MyPipeline pipeline : pipelines) {
            mySpider.addPipeline(MyCrawlerUtil.createPipeline(site, pipeline, scheduler));
        }
        return mySpider;
    }

    private static final PageProcessor createPageProcessor(final MySite site, final MyPageProcessor pageProcessor) {
        return new PageProcessor(){

            public void process(Page page) {
                int depth = (Integer)ObjectUtil.defaultIfNull((Object)page.getRequest().getExtra(MyCrawlerUtil.depthExtraKey), (Object)1);
                MyProcessPage myPage = new MyProcessPage(depth, site, page);
                pageProcessor.process(myPage);
                List targetRequests = page.getTargetRequests();
                if (CollUtil.isNotEmpty((Collection)targetRequests)) {
                    page.getTargetRequests().forEach(it -> it.putExtra(MyCrawlerUtil.depthExtraKey, (Object)(depth + 1)));
                    if (site.getMaxDepth() > 0 && depth >= site.getMaxDepth()) {
                        page.getTargetRequests().clear();
                    }
                }
            }

            public Site getSite() {
                return site;
            }
        };
    }

    private static final Pipeline createPipeline(MySite site, final MyPipeline pipeline, final MyDuplicateVerify duplicateVerify) {
        return new Pipeline(){

            public void process(ResultItems resultItems, Task task) {
                MyProcessPipe myData = new MyProcessPipe(task, resultItems, duplicateVerify);
                pipeline.process(myData);
            }
        };
    }

    private MyCrawlerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

