/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.util;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public final class MergeUtil {
    public static final void mergeComplexTitle(Sheet sh, MergeCellPoints points) {
        for (CellRangeAddress merge : points.getRanges()) {
            sh.addMergedRegion(merge);
        }
    }

    public static final MergeCellPoints findCellRangeAddress(int titleRowPos, int rowNbr, Map<String, List<Integer[]>> titleRowColMap) {
        MergeCellPoints points = MergeCellPoints.builder().build();
        for (Map.Entry<String, List<Integer[]>> titleEntry : titleRowColMap.entrySet()) {
            int colIndex;
            int rowIndex;
            List<Integer[]> rowColList = titleEntry.getValue();
            if (rowColList.size() <= 1) continue;
            MergeArea ma = MergeArea.builder().title(titleEntry.getKey()).titleRowPos(titleRowPos).titleRowNbr(rowNbr).build();
            for (Integer[] point : rowColList) {
                rowIndex = point[0];
                colIndex = point[1];
                ma.pushRowColPoint(rowIndex, colIndex);
                ma.pushColRowPoint(rowIndex, colIndex);
            }
            for (Integer[] point : rowColList) {
                rowIndex = point[0];
                colIndex = point[1];
                Map<Integer, Map<Integer, String>> exMap = points.getExcludeRowColMap();
                if (exMap.containsKey(rowIndex) && exMap.get(rowIndex).containsKey(colIndex)) continue;
                MergeUtil.changeMergeArea(ma, rowIndex, colIndex, points);
            }
        }
        return points;
    }

    public static final Cell findFirstCellOfUnitRegion(Sheet sh, int rowIndex, int columnIndex) {
        CellRangeAddress area = MergeUtil.findUnitRegion(sh, rowIndex, columnIndex);
        return sh.getRow(area.getFirstRow()).getCell(area.getFirstColumn());
    }

    public static final void pushTitleRowColMap(Map<String, List<Integer[]>> map, String title, Integer[] point) {
        List<Integer[]> list = map.get(title);
        if (list == null) {
            list = new ArrayList<Integer[]>();
            map.put(title, list);
        }
        list.add(point);
    }

    private static final CellRangeAddress findUnitRegion(Sheet sh, int rowIndex, int columnIndex) {
        int sheetMergeCount = sh.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sh.getMergedRegion(i);
            int firstCol = range.getFirstColumn();
            int lastCol = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (rowIndex < firstRow || rowIndex > lastRow || columnIndex < firstCol || columnIndex > lastCol) continue;
            return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        }
        return new CellRangeAddress(rowIndex, rowIndex, columnIndex, columnIndex);
    }

    private static final void pushPointTitleMap(Map<Integer, Map<Integer, String>> map, int key1, int key2, String title) {
        Map<Integer, String> map2 = map.get(key1);
        if (map2 == null) {
            map2 = new LinkedHashMap<Integer, String>();
            map.put(key1, map2);
        }
        map2.put(key2, title);
    }

    private static final void changeMergeArea(MergeArea ma, int rowIndex, int colIndex, MergeCellPoints mp) {
        boolean isMerge = false;
        boolean isAddToCellRangeAddress = true;
        Map<Integer, Map<Integer, String>> _RowColPointMap = ma.get_RowColPointMap();
        Map<Integer, Map<Integer, String>> _ColRowPointMap = ma.get_ColRowPointMap();
        int rowCount = _RowColPointMap.size();
        int colCount = _ColRowPointMap.size();
        if (rowCount == 1 && colCount == 1) {
            ma.reset();
            return;
        }
        if (rowCount == 1 || colCount == 1) {
            isMerge = MergeUtil.isPointOfMergeSingleRowOrCol(ma, rowIndex, colIndex);
        } else {
            Boolean[] multiBools = MergeUtil.isPointOfMergeMultiRowCol(ma, rowIndex, colIndex, mp);
            isMerge = multiBools[0];
            isAddToCellRangeAddress = multiBools[1];
        }
        MergeUtil._actionMergeAreaChange(ma, rowIndex, colIndex);
        if (isMerge) {
            if (isAddToCellRangeAddress) {
                MergeUtil.addToCellRangeAddressList(mp, ma);
            }
            ma.reset();
        }
    }

    private static final void _actionMergeAreaChange(MergeArea ma, int rowIndex, int colIndex) {
        ma.setFirstRow(ma.getFirstRow() < 0 ? rowIndex : Math.min(ma.getFirstRow(), rowIndex));
        ma.setLastRow(ma.getLastRow() < 0 ? rowIndex : Math.max(ma.getLastRow(), rowIndex));
        ma.setFirstCol(ma.getFirstCol() < 0 ? colIndex : Math.min(ma.getFirstCol(), colIndex));
        ma.setLastCol(ma.getLastCol() < 0 ? colIndex : Math.max(ma.getLastCol(), colIndex));
        ma.setPrevRowIndex(rowIndex);
        ma.setPrevColIndex(colIndex);
    }

    private static final boolean isPointOfMergeSingleRowOrCol(MergeArea ma, int rowIndex, int colIndex) {
        boolean isMerge = false;
        Map<Integer, Map<Integer, String>> _RowColPointMap = ma.get_RowColPointMap();
        Map<Integer, Map<Integer, String>> _ColRowPointMap = ma.get_ColRowPointMap();
        if (_RowColPointMap.size() == 1) {
            isMerge = !_RowColPointMap.get(rowIndex).containsKey(colIndex + 1);
        } else if (_ColRowPointMap.size() == 1) {
            isMerge = !_ColRowPointMap.get(colIndex).containsKey(rowIndex + 1);
        }
        return isMerge;
    }

    private static final Boolean[] isPointOfMergeMultiRowCol(MergeArea ma, int rowIndex, int colIndex, MergeCellPoints mp) {
        boolean isLastRow;
        boolean isMerge = false;
        boolean isAddToCellRangeAddress = true;
        Map<Integer, Map<Integer, String>> _RowColPointMap = ma.get_RowColPointMap();
        boolean isOverRow = !_RowColPointMap.get(rowIndex).containsKey(colIndex + 1);
        boolean bl = isLastRow = !_RowColPointMap.containsKey(rowIndex + 1);
        if (isOverRow) {
            Map<Integer, String> _ColPointMap = _RowColPointMap.get(rowIndex);
            if (isLastRow) {
                isMerge = true;
            } else {
                Map<Integer, String> _ColPointMapOfNextRow = _RowColPointMap.get(rowIndex + 1);
                int i = colIndex;
                while (_ColPointMap.containsKey(i)) {
                    if (!_ColPointMapOfNextRow.containsKey(i)) {
                        isMerge = true;
                        break;
                    }
                    --i;
                }
                if (!isMerge) {
                    MergeUtil._actionMergeAreaChange(ma, rowIndex, colIndex);
                    MergeUtil.drillingDown(ma, rowIndex + 1, colIndex, mp);
                    isAddToCellRangeAddress = false;
                    isMerge = true;
                }
            }
        }
        return new Boolean[]{isMerge, isAddToCellRangeAddress};
    }

    private static final void drillingDown(MergeArea ma, int rowIndex, int colIndex, MergeCellPoints mp) {
        boolean isMerge = false;
        int nextRowIndex = rowIndex + 1;
        MergeUtil._actionMergeAreaChange(ma, rowIndex, colIndex);
        Map<Integer, Map<Integer, String>> _RowColPointMap = ma.get_RowColPointMap();
        boolean isLastRow = !_RowColPointMap.containsKey(nextRowIndex);
        Map<Integer, String> _ColPointMap = _RowColPointMap.get(rowIndex);
        Map<Integer, String> _ColPointMapOfNextRow = _RowColPointMap.get(nextRowIndex);
        int i = colIndex;
        while (_ColPointMap.containsKey(i)) {
            if (isLastRow) {
                MergeArea temp = MergeArea.builder().title(ma.getTitle()).titleRowPos(ma.getTitleRowPos()).titleRowNbr(ma.getTitleRowNbr()).firstRow(ma.getFirstRow()).lastRow(ma.getLastRow()).firstCol(i).lastCol(i)._RowColPointMap(ma.get_RowColPointMap())._ColRowPointMap(ma.get_ColRowPointMap()).build();
                MergeUtil.addToCellRangeAddressList(mp, temp);
                isMerge = true;
            } else if (!_ColPointMapOfNextRow.containsKey(i)) {
                MergeUtil.addToCellRangeAddressList(mp, ma);
                isMerge = true;
                break;
            }
            --i;
        }
        if (!isMerge) {
            MergeUtil.drillingDown(ma, nextRowIndex, colIndex, mp);
        }
        if (isLastRow || !isMerge) {
            i = colIndex;
            while (_ColPointMap.containsKey(i)) {
                mp.exclude(rowIndex, i, ma.getTitle());
                --i;
            }
        }
    }

    private static final void addToCellRangeAddressList(MergeCellPoints mp, MergeArea ma) {
        int firstRow = ma.getFirstRow();
        int lastRow = ma.getLastRow();
        int firstCol = ma.getFirstCol();
        int lastCol = ma.getLastCol();
        if (firstRow >= 0 && lastRow >= 0 && firstCol >= 0 && lastCol >= 0 && (firstRow != lastRow || firstCol != lastCol)) {
            String key = firstRow + File.separator + lastRow + File.separator + firstCol + File.separator + lastCol;
            if (!mp.pools.containsKey(key)) {
                CellRangeAddress area = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
                mp.getRanges().add(area);
                mp.pools.put(key, area);
            }
        }
    }

    private MergeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class MergeArea {
        private String title;
        private int titleRowPos;
        private int titleRowNbr;
        private Integer firstRow;
        private Integer lastRow;
        private Integer firstCol;
        private Integer lastCol;
        private Integer prevRowIndex;
        private Integer prevColIndex;
        private Map<Integer, Map<Integer, String>> _RowColPointMap;
        private Map<Integer, Map<Integer, String>> _ColRowPointMap;

        public void reset() {
            this.firstRow = -100;
            this.lastRow = -100;
            this.firstCol = -100;
            this.lastCol = -100;
            this.prevRowIndex = -100;
            this.prevColIndex = -100;
        }

        public void pushRowColPoint(int rowIndex, int colIndex) {
            MergeUtil.pushPointTitleMap(this._RowColPointMap, rowIndex, colIndex, this.title);
        }

        public void pushColRowPoint(int rowIndex, int colIndex) {
            MergeUtil.pushPointTitleMap(this._ColRowPointMap, colIndex, rowIndex, this.title);
        }

        private static Integer $default$firstRow() {
            return -100;
        }

        private static Integer $default$lastRow() {
            return -100;
        }

        private static Integer $default$firstCol() {
            return -100;
        }

        private static Integer $default$lastCol() {
            return -100;
        }

        private static Integer $default$prevRowIndex() {
            return -100;
        }

        private static Integer $default$prevColIndex() {
            return -100;
        }

        private static Map<Integer, Map<Integer, String>> $default$_RowColPointMap() {
            return new LinkedHashMap<Integer, Map<Integer, String>>();
        }

        private static Map<Integer, Map<Integer, String>> $default$_ColRowPointMap() {
            return new LinkedHashMap<Integer, Map<Integer, String>>();
        }

        MergeArea(String title, int titleRowPos, int titleRowNbr, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol, Integer prevRowIndex, Integer prevColIndex, Map<Integer, Map<Integer, String>> _RowColPointMap, Map<Integer, Map<Integer, String>> _ColRowPointMap) {
            this.title = title;
            this.titleRowPos = titleRowPos;
            this.titleRowNbr = titleRowNbr;
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            this.firstCol = firstCol;
            this.lastCol = lastCol;
            this.prevRowIndex = prevRowIndex;
            this.prevColIndex = prevColIndex;
            this._RowColPointMap = _RowColPointMap;
            this._ColRowPointMap = _ColRowPointMap;
        }

        public static MergeAreaBuilder builder() {
            return new MergeAreaBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public int getTitleRowPos() {
            return this.titleRowPos;
        }

        public int getTitleRowNbr() {
            return this.titleRowNbr;
        }

        public Integer getFirstRow() {
            return this.firstRow;
        }

        public Integer getLastRow() {
            return this.lastRow;
        }

        public Integer getFirstCol() {
            return this.firstCol;
        }

        public Integer getLastCol() {
            return this.lastCol;
        }

        public Integer getPrevRowIndex() {
            return this.prevRowIndex;
        }

        public Integer getPrevColIndex() {
            return this.prevColIndex;
        }

        public Map<Integer, Map<Integer, String>> get_RowColPointMap() {
            return this._RowColPointMap;
        }

        public Map<Integer, Map<Integer, String>> get_ColRowPointMap() {
            return this._ColRowPointMap;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setTitleRowPos(int titleRowPos) {
            this.titleRowPos = titleRowPos;
        }

        public void setTitleRowNbr(int titleRowNbr) {
            this.titleRowNbr = titleRowNbr;
        }

        public void setFirstRow(Integer firstRow) {
            this.firstRow = firstRow;
        }

        public void setLastRow(Integer lastRow) {
            this.lastRow = lastRow;
        }

        public void setFirstCol(Integer firstCol) {
            this.firstCol = firstCol;
        }

        public void setLastCol(Integer lastCol) {
            this.lastCol = lastCol;
        }

        public void setPrevRowIndex(Integer prevRowIndex) {
            this.prevRowIndex = prevRowIndex;
        }

        public void setPrevColIndex(Integer prevColIndex) {
            this.prevColIndex = prevColIndex;
        }

        public void set_RowColPointMap(Map<Integer, Map<Integer, String>> _RowColPointMap) {
            this._RowColPointMap = _RowColPointMap;
        }

        public void set_ColRowPointMap(Map<Integer, Map<Integer, String>> _ColRowPointMap) {
            this._ColRowPointMap = _ColRowPointMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeArea)) {
                return false;
            }
            MergeArea other = (MergeArea)o;
            if (this.getTitleRowPos() != other.getTitleRowPos()) {
                return false;
            }
            if (this.getTitleRowNbr() != other.getTitleRowNbr()) {
                return false;
            }
            Integer this$firstRow = this.getFirstRow();
            Integer other$firstRow = other.getFirstRow();
            if (this$firstRow == null ? other$firstRow != null : !((Object)this$firstRow).equals(other$firstRow)) {
                return false;
            }
            Integer this$lastRow = this.getLastRow();
            Integer other$lastRow = other.getLastRow();
            if (this$lastRow == null ? other$lastRow != null : !((Object)this$lastRow).equals(other$lastRow)) {
                return false;
            }
            Integer this$firstCol = this.getFirstCol();
            Integer other$firstCol = other.getFirstCol();
            if (this$firstCol == null ? other$firstCol != null : !((Object)this$firstCol).equals(other$firstCol)) {
                return false;
            }
            Integer this$lastCol = this.getLastCol();
            Integer other$lastCol = other.getLastCol();
            if (this$lastCol == null ? other$lastCol != null : !((Object)this$lastCol).equals(other$lastCol)) {
                return false;
            }
            Integer this$prevRowIndex = this.getPrevRowIndex();
            Integer other$prevRowIndex = other.getPrevRowIndex();
            if (this$prevRowIndex == null ? other$prevRowIndex != null : !((Object)this$prevRowIndex).equals(other$prevRowIndex)) {
                return false;
            }
            Integer this$prevColIndex = this.getPrevColIndex();
            Integer other$prevColIndex = other.getPrevColIndex();
            if (this$prevColIndex == null ? other$prevColIndex != null : !((Object)this$prevColIndex).equals(other$prevColIndex)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Map<Integer, Map<Integer, String>> this$_RowColPointMap = this.get_RowColPointMap();
            Map<Integer, Map<Integer, String>> other$_RowColPointMap = other.get_RowColPointMap();
            if (this$_RowColPointMap == null ? other$_RowColPointMap != null : !((Object)this$_RowColPointMap).equals(other$_RowColPointMap)) {
                return false;
            }
            Map<Integer, Map<Integer, String>> this$_ColRowPointMap = this.get_ColRowPointMap();
            Map<Integer, Map<Integer, String>> other$_ColRowPointMap = other.get_ColRowPointMap();
            return !(this$_ColRowPointMap == null ? other$_ColRowPointMap != null : !((Object)this$_ColRowPointMap).equals(other$_ColRowPointMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTitleRowPos();
            result = result * 59 + this.getTitleRowNbr();
            Integer $firstRow = this.getFirstRow();
            result = result * 59 + ($firstRow == null ? 43 : ((Object)$firstRow).hashCode());
            Integer $lastRow = this.getLastRow();
            result = result * 59 + ($lastRow == null ? 43 : ((Object)$lastRow).hashCode());
            Integer $firstCol = this.getFirstCol();
            result = result * 59 + ($firstCol == null ? 43 : ((Object)$firstCol).hashCode());
            Integer $lastCol = this.getLastCol();
            result = result * 59 + ($lastCol == null ? 43 : ((Object)$lastCol).hashCode());
            Integer $prevRowIndex = this.getPrevRowIndex();
            result = result * 59 + ($prevRowIndex == null ? 43 : ((Object)$prevRowIndex).hashCode());
            Integer $prevColIndex = this.getPrevColIndex();
            result = result * 59 + ($prevColIndex == null ? 43 : ((Object)$prevColIndex).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Map<Integer, Map<Integer, String>> $_RowColPointMap = this.get_RowColPointMap();
            result = result * 59 + ($_RowColPointMap == null ? 43 : ((Object)$_RowColPointMap).hashCode());
            Map<Integer, Map<Integer, String>> $_ColRowPointMap = this.get_ColRowPointMap();
            result = result * 59 + ($_ColRowPointMap == null ? 43 : ((Object)$_ColRowPointMap).hashCode());
            return result;
        }

        public String toString() {
            return "MergeUtil.MergeArea(title=" + this.getTitle() + ", titleRowPos=" + this.getTitleRowPos() + ", titleRowNbr=" + this.getTitleRowNbr() + ", firstRow=" + this.getFirstRow() + ", lastRow=" + this.getLastRow() + ", firstCol=" + this.getFirstCol() + ", lastCol=" + this.getLastCol() + ", prevRowIndex=" + this.getPrevRowIndex() + ", prevColIndex=" + this.getPrevColIndex() + ", _RowColPointMap=" + this.get_RowColPointMap() + ", _ColRowPointMap=" + this.get_ColRowPointMap() + ")";
        }

        public static class MergeAreaBuilder {
            private String title;
            private int titleRowPos;
            private int titleRowNbr;
            private boolean firstRow$set;
            private Integer firstRow$value;
            private boolean lastRow$set;
            private Integer lastRow$value;
            private boolean firstCol$set;
            private Integer firstCol$value;
            private boolean lastCol$set;
            private Integer lastCol$value;
            private boolean prevRowIndex$set;
            private Integer prevRowIndex$value;
            private boolean prevColIndex$set;
            private Integer prevColIndex$value;
            private boolean _RowColPointMap$set;
            private Map<Integer, Map<Integer, String>> _RowColPointMap$value;
            private boolean _ColRowPointMap$set;
            private Map<Integer, Map<Integer, String>> _ColRowPointMap$value;

            MergeAreaBuilder() {
            }

            public MergeAreaBuilder title(String title) {
                this.title = title;
                return this;
            }

            public MergeAreaBuilder titleRowPos(int titleRowPos) {
                this.titleRowPos = titleRowPos;
                return this;
            }

            public MergeAreaBuilder titleRowNbr(int titleRowNbr) {
                this.titleRowNbr = titleRowNbr;
                return this;
            }

            public MergeAreaBuilder firstRow(Integer firstRow) {
                this.firstRow$value = firstRow;
                this.firstRow$set = true;
                return this;
            }

            public MergeAreaBuilder lastRow(Integer lastRow) {
                this.lastRow$value = lastRow;
                this.lastRow$set = true;
                return this;
            }

            public MergeAreaBuilder firstCol(Integer firstCol) {
                this.firstCol$value = firstCol;
                this.firstCol$set = true;
                return this;
            }

            public MergeAreaBuilder lastCol(Integer lastCol) {
                this.lastCol$value = lastCol;
                this.lastCol$set = true;
                return this;
            }

            public MergeAreaBuilder prevRowIndex(Integer prevRowIndex) {
                this.prevRowIndex$value = prevRowIndex;
                this.prevRowIndex$set = true;
                return this;
            }

            public MergeAreaBuilder prevColIndex(Integer prevColIndex) {
                this.prevColIndex$value = prevColIndex;
                this.prevColIndex$set = true;
                return this;
            }

            public MergeAreaBuilder _RowColPointMap(Map<Integer, Map<Integer, String>> _RowColPointMap) {
                this._RowColPointMap$value = _RowColPointMap;
                this._RowColPointMap$set = true;
                return this;
            }

            public MergeAreaBuilder _ColRowPointMap(Map<Integer, Map<Integer, String>> _ColRowPointMap) {
                this._ColRowPointMap$value = _ColRowPointMap;
                this._ColRowPointMap$set = true;
                return this;
            }

            public MergeArea build() {
                Integer firstRow$value = this.firstRow$value;
                if (!this.firstRow$set) {
                    firstRow$value = MergeArea.$default$firstRow();
                }
                Integer lastRow$value = this.lastRow$value;
                if (!this.lastRow$set) {
                    lastRow$value = MergeArea.$default$lastRow();
                }
                Integer firstCol$value = this.firstCol$value;
                if (!this.firstCol$set) {
                    firstCol$value = MergeArea.$default$firstCol();
                }
                Integer lastCol$value = this.lastCol$value;
                if (!this.lastCol$set) {
                    lastCol$value = MergeArea.$default$lastCol();
                }
                Integer prevRowIndex$value = this.prevRowIndex$value;
                if (!this.prevRowIndex$set) {
                    prevRowIndex$value = MergeArea.$default$prevRowIndex();
                }
                Integer prevColIndex$value = this.prevColIndex$value;
                if (!this.prevColIndex$set) {
                    prevColIndex$value = MergeArea.$default$prevColIndex();
                }
                Map _RowColPointMap$value = this._RowColPointMap$value;
                if (!this._RowColPointMap$set) {
                    _RowColPointMap$value = MergeArea.$default$_RowColPointMap();
                }
                Map _ColRowPointMap$value = this._ColRowPointMap$value;
                if (!this._ColRowPointMap$set) {
                    _ColRowPointMap$value = MergeArea.$default$_ColRowPointMap();
                }
                return new MergeArea(this.title, this.titleRowPos, this.titleRowNbr, firstRow$value, lastRow$value, firstCol$value, lastCol$value, prevRowIndex$value, prevColIndex$value, _RowColPointMap$value, _ColRowPointMap$value);
            }

            public String toString() {
                return "MergeUtil.MergeArea.MergeAreaBuilder(title=" + this.title + ", titleRowPos=" + this.titleRowPos + ", titleRowNbr=" + this.titleRowNbr + ", firstRow$value=" + this.firstRow$value + ", lastRow$value=" + this.lastRow$value + ", firstCol$value=" + this.firstCol$value + ", lastCol$value=" + this.lastCol$value + ", prevRowIndex$value=" + this.prevRowIndex$value + ", prevColIndex$value=" + this.prevColIndex$value + ", _RowColPointMap$value=" + this._RowColPointMap$value + ", _ColRowPointMap$value=" + this._ColRowPointMap$value + ")";
            }
        }
    }

    private static final class MergeCellPoints {
        private Map<String, CellRangeAddress> pools;
        private List<CellRangeAddress> ranges;
        private Map<Integer, Map<Integer, String>> excludeRowColMap;

        public void exclude(int rowIndex, int colIndex, String title) {
            MergeUtil.pushPointTitleMap(this.excludeRowColMap, rowIndex, colIndex, title);
        }

        private static Map<String, CellRangeAddress> $default$pools() {
            return new LinkedHashMap<String, CellRangeAddress>();
        }

        private static List<CellRangeAddress> $default$ranges() {
            return new ArrayList<CellRangeAddress>();
        }

        private static Map<Integer, Map<Integer, String>> $default$excludeRowColMap() {
            return new LinkedHashMap<Integer, Map<Integer, String>>();
        }

        MergeCellPoints(Map<String, CellRangeAddress> pools, List<CellRangeAddress> ranges, Map<Integer, Map<Integer, String>> excludeRowColMap) {
            this.pools = pools;
            this.ranges = ranges;
            this.excludeRowColMap = excludeRowColMap;
        }

        public static MergeCellPointsBuilder builder() {
            return new MergeCellPointsBuilder();
        }

        public Map<String, CellRangeAddress> getPools() {
            return this.pools;
        }

        public List<CellRangeAddress> getRanges() {
            return this.ranges;
        }

        public Map<Integer, Map<Integer, String>> getExcludeRowColMap() {
            return this.excludeRowColMap;
        }

        public void setPools(Map<String, CellRangeAddress> pools) {
            this.pools = pools;
        }

        public void setRanges(List<CellRangeAddress> ranges) {
            this.ranges = ranges;
        }

        public void setExcludeRowColMap(Map<Integer, Map<Integer, String>> excludeRowColMap) {
            this.excludeRowColMap = excludeRowColMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeCellPoints)) {
                return false;
            }
            MergeCellPoints other = (MergeCellPoints)o;
            Map<String, CellRangeAddress> this$pools = this.getPools();
            Map<String, CellRangeAddress> other$pools = other.getPools();
            if (this$pools == null ? other$pools != null : !((Object)this$pools).equals(other$pools)) {
                return false;
            }
            List<CellRangeAddress> this$ranges = this.getRanges();
            List<CellRangeAddress> other$ranges = other.getRanges();
            if (this$ranges == null ? other$ranges != null : !((Object)this$ranges).equals(other$ranges)) {
                return false;
            }
            Map<Integer, Map<Integer, String>> this$excludeRowColMap = this.getExcludeRowColMap();
            Map<Integer, Map<Integer, String>> other$excludeRowColMap = other.getExcludeRowColMap();
            return !(this$excludeRowColMap == null ? other$excludeRowColMap != null : !((Object)this$excludeRowColMap).equals(other$excludeRowColMap));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, CellRangeAddress> $pools = this.getPools();
            result = result * 59 + ($pools == null ? 43 : ((Object)$pools).hashCode());
            List<CellRangeAddress> $ranges = this.getRanges();
            result = result * 59 + ($ranges == null ? 43 : ((Object)$ranges).hashCode());
            Map<Integer, Map<Integer, String>> $excludeRowColMap = this.getExcludeRowColMap();
            result = result * 59 + ($excludeRowColMap == null ? 43 : ((Object)$excludeRowColMap).hashCode());
            return result;
        }

        public String toString() {
            return "MergeUtil.MergeCellPoints(pools=" + this.getPools() + ", ranges=" + this.getRanges() + ", excludeRowColMap=" + this.getExcludeRowColMap() + ")";
        }

        public static class MergeCellPointsBuilder {
            private boolean pools$set;
            private Map<String, CellRangeAddress> pools$value;
            private boolean ranges$set;
            private List<CellRangeAddress> ranges$value;
            private boolean excludeRowColMap$set;
            private Map<Integer, Map<Integer, String>> excludeRowColMap$value;

            MergeCellPointsBuilder() {
            }

            public MergeCellPointsBuilder pools(Map<String, CellRangeAddress> pools) {
                this.pools$value = pools;
                this.pools$set = true;
                return this;
            }

            public MergeCellPointsBuilder ranges(List<CellRangeAddress> ranges) {
                this.ranges$value = ranges;
                this.ranges$set = true;
                return this;
            }

            public MergeCellPointsBuilder excludeRowColMap(Map<Integer, Map<Integer, String>> excludeRowColMap) {
                this.excludeRowColMap$value = excludeRowColMap;
                this.excludeRowColMap$set = true;
                return this;
            }

            public MergeCellPoints build() {
                Map pools$value = this.pools$value;
                if (!this.pools$set) {
                    pools$value = MergeCellPoints.$default$pools();
                }
                List ranges$value = this.ranges$value;
                if (!this.ranges$set) {
                    ranges$value = MergeCellPoints.$default$ranges();
                }
                Map excludeRowColMap$value = this.excludeRowColMap$value;
                if (!this.excludeRowColMap$set) {
                    excludeRowColMap$value = MergeCellPoints.$default$excludeRowColMap();
                }
                return new MergeCellPoints(pools$value, ranges$value, excludeRowColMap$value);
            }

            public String toString() {
                return "MergeUtil.MergeCellPoints.MergeCellPointsBuilder(pools$value=" + this.pools$value + ", ranges$value=" + this.ranges$value + ", excludeRowColMap$value=" + this.excludeRowColMap$value + ")";
            }
        }
    }
}

