/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.handler;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.MyExcel.config.MyColumn;
import cn.renlm.plugins.MyExcel.config.MySheet;
import cn.renlm.plugins.MyExcel.config.column.Dict;
import cn.renlm.plugins.MyExcel.entity.CheckResult;
import java.util.Date;
import java.util.Map;

@FunctionalInterface
public interface DataReadHandler {
    public void handle(Map<String, Object> var1, CheckResult var2);

    default public CheckResult readConvert(MySheet sheet, long rowIndex, Map<String, Object> data) {
        CheckResult checkResult = new CheckResult().setRowIndex(rowIndex).setProcess(true);
        Map<String, MyColumn> fieldColMap = sheet.getFieldColMap();
        for (Map.Entry<String, MyColumn> entry : fieldColMap.entrySet()) {
            String valStr;
            String field = entry.getKey();
            MyColumn col = entry.getValue();
            Object value = data.get(field);
            if (col.isIgnore() || StrUtil.isBlankIfStr((Object)value)) {
                data.put(field, null);
                continue;
            }
            if (StrUtil.isNotBlank((CharSequence)col.getPrefix()) && data.get(field).toString().startsWith(col.getPrefix())) {
                valStr = data.get(field).toString();
                data.put(field, StrUtil.removePrefix((CharSequence)valStr, (CharSequence)col.getPrefix()));
            }
            if (StrUtil.isNotBlank((CharSequence)col.getSuffix()) && data.get(field).toString().endsWith(col.getSuffix())) {
                valStr = data.get(field).toString();
                data.put(field, StrUtil.removeSuffix((CharSequence)valStr, (CharSequence)col.getSuffix()));
            }
            if (col.getDict() != null) {
                Dict.DictItem di;
                valStr = data.get(field).toString();
                if (col.getDict().getType() == Dict.DictType.key) {
                    di = col.getDict().getKeyMap().get(valStr);
                    if (di != null && StrUtil.isNotBlank((CharSequence)col.getDict().getConvertToField())) {
                        data.put(col.getDict().getConvertToField(), di.getValue());
                    }
                } else if (col.getDict().getType() == Dict.DictType.value && (di = col.getDict().getValMap().get(valStr)) != null) {
                    valStr = di.getKey();
                    data.put(field, valStr);
                }
            }
            if (StrUtil.isNotBlank((CharSequence)col.getNumberFormat())) {
                valStr = data.get(field).toString();
                data.put(field, NumberUtil.parseNumber((String)valStr));
            }
            if (StrUtil.isNotBlank((CharSequence)col.getDateFormat()) && !(data.get(field) instanceof Date)) {
                try {
                    valStr = data.get(field).toString();
                    data.put(field, DateUtil.parse((CharSequence)valStr, (String)col.getDateFormat()));
                }
                catch (Exception e) {
                    data.put(field, null);
                    String message = StrUtil.format((CharSequence)"{}\uff0c\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u9650\u5b9a{}", (Object[])new Object[]{col.getTitle().getText(), col.getDateFormat()});
                    checkResult.getErrors().add(message);
                    System.err.println(message);
                }
            }
            if (!col.isNotNull() || !StrUtil.isBlankIfStr((Object)data.get(field))) continue;
            String message = StrUtil.format((CharSequence)"{}\uff0c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{col.getTitle().getText()});
            checkResult.getErrors().add(message);
            System.err.println(message);
        }
        return checkResult;
    }
}

