/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler.scheduler;

import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.scheduler.DuplicateRemovedScheduler;
import us.codecraft.webmagic.scheduler.MonitorableScheduler;
import us.codecraft.webmagic.scheduler.component.DuplicateRemover;

public class MyRedisScheduler
extends DuplicateRemovedScheduler
implements MonitorableScheduler,
DuplicateRemover {
    protected JedisPool pool;
    private static final String QUEUE_PREFIX = "queue_";
    private static final String SET_PREFIX = "set_";
    private static final String ITEM_PREFIX = "item_";

    public MyRedisScheduler(JedisPool pool) {
        this.pool = pool;
        this.setDuplicateRemover(this);
    }

    public void resetDuplicateCheck(Task task) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(this.getSetKey(task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDuplicate(Request request, Task task) {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.sadd(this.getSetKey(task), new String[]{request.getUrl()}) == 0L;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushWhenNoDuplicate(Request request, Task task) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.rpush(this.getQueueKey(task), new String[]{request.getUrl()});
            if (this.checkForAdditionalInfo(request)) {
                String field = DigestUtils.sha1Hex((String)request.getUrl());
                String value = JSON.toJSONString((Object)request);
                jedis.hset(ITEM_PREFIX + task.getUUID(), field, value);
            }
        }
    }

    private boolean checkForAdditionalInfo(Request request) {
        if (request == null) {
            return false;
        }
        if (!request.getHeaders().isEmpty() || !request.getCookies().isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCharset()) || StringUtils.isNotBlank((CharSequence)request.getMethod())) {
            return true;
        }
        if (request.isBinaryContent() || request.getRequestBody() != null) {
            return true;
        }
        if (request.getExtras() != null && !request.getExtras().isEmpty()) {
            return true;
        }
        return request.getPriority() != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Request poll(Task task) {
        try (Jedis jedis = this.pool.getResource();){
            Request request;
            String url = jedis.lpop(this.getQueueKey(task));
            if (url == null) {
                Request request2 = null;
                return request2;
            }
            String key = ITEM_PREFIX + task.getUUID();
            String field = DigestUtils.sha1Hex((String)url);
            byte[] bytes = jedis.hget(key.getBytes(), field.getBytes());
            if (bytes != null) {
                Request o;
                Request request3 = o = (Request)JSON.parseObject((String)new String(bytes), Request.class);
                return request3;
            }
            Request request4 = request = new Request(url);
            return request4;
        }
    }

    protected String getSetKey(Task task) {
        return SET_PREFIX + task.getUUID();
    }

    protected String getQueueKey(Task task) {
        return QUEUE_PREFIX + task.getUUID();
    }

    protected String getItemKey(Task task) {
        return ITEM_PREFIX + task.getUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeftRequestsCount(Task task) {
        try (Jedis jedis = this.pool.getResource();){
            Long size = jedis.llen(this.getQueueKey(task));
            int n = size.intValue();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalRequestsCount(Task task) {
        try (Jedis jedis = this.pool.getResource();){
            Long size = jedis.scard(this.getSetKey(task));
            int n = size.intValue();
            return n;
        }
    }
}

