/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.hutool.core.util.ClassUtil;
import cn.renlm.plugins.MyUtil.MyXStreamUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IFileCreate;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import com.baomidou.mybatisplus.generator.config.rules.DbColumnType;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MyGeneratorUtil {
    public static final String projectPath = System.getProperty("user.dir");
    public static final String javaDir = projectPath + "/src/main/java";
    public static final String resourcesDir = projectPath + "/src/main/resources";
    static final String mapperSuffix = "Mapper";
    static final String mapperOutputDir = projectPath + "/src/main/resources/mapper";
    static final String mapperTemplatePath = "/templates/mapper.xml.ftl";
    static final String serviceImplTemplatePath = "config/ServiceImpl.java";
    static final String dSClassName = "com.baomidou.dynamic.datasource.annotation.DS";

    public static final void run(String xml) {
        GeneratorConfig conf = MyXStreamUtil.read(GeneratorConfig.class, xml);
        DataSourceConfig dsc = new DataSourceConfig().setUrl(conf.url).setUsername(conf.username).setPassword(conf.password).setDriverName(conf.driverName);
        DbType dbType = dsc.getDbType();
        if (dbType == DbType.POSTGRE_SQL) {
            dsc.setTypeConvert((ITypeConvert)new PostgreSqlTypeConvert(){

                public IColumnType processTypeConvert(GlobalConfig globalConfig, String fieldType) {
                    if (fieldType.toLowerCase().contains("bytea")) {
                        return DbColumnType.BYTE_ARRAY;
                    }
                    return super.processTypeConvert(globalConfig, fieldType);
                }
            });
        }
        conf.modules.forEach(module -> ((GeneratorModule)module).tables.forEach(table -> MyGeneratorUtil.create(conf, dsc, ((GeneratorModule)module).pkg, ((GeneratorModule)module).name, table)));
    }

    private static final void create(final GeneratorConfig conf, DataSourceConfig dsc, String pkg, String moduleName, final GeneratorTable table) {
        AutoGenerator mpg = new AutoGenerator();
        mpg.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        GlobalConfig gc = new GlobalConfig();
        gc.setOutputDir(javaDir);
        gc.setAuthor(table.author);
        gc.setOpen(false);
        gc.setIdType(table.idType == null ? IdType.AUTO : IdType.valueOf((String)table.idType));
        gc.setDateType(DateType.ONLY_DATE);
        mpg.setGlobalConfig(gc);
        mpg.setDataSource(dsc);
        final PackageConfig pc = new PackageConfig();
        pc.setModuleName(moduleName);
        pc.setParent(pkg);
        mpg.setPackageInfo(pc);
        InjectionConfig cfg = new InjectionConfig(){

            public void initMap() {
                HashMap<String, String> map = new HashMap<String, String>();
                Class dsClass = null;
                try {
                    dsClass = ClassUtil.loadClass((String)MyGeneratorUtil.dSClassName);
                    map.put("nameOfDS", dsClass.getName());
                    map.put("dsName", conf.dsName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setMap(map);
            }
        };
        ArrayList<3> focList = new ArrayList<3>();
        focList.add(new FileOutConfig(mapperTemplatePath){

            public String outputFile(TableInfo tableInfo) {
                return mapperOutputDir + "/" + pc.getModuleName() + "/" + tableInfo.getEntityName() + MyGeneratorUtil.mapperSuffix + ".xml";
            }
        });
        cfg.setFileCreate(new IFileCreate(){

            public boolean isCreate(ConfigBuilder configBuilder, FileType fileType, String filePath) {
                this.checkDir(filePath);
                return fileType == FileType.ENTITY && table.coverEntity || !new File(filePath).exists();
            }

            public void checkDir(String filePath) {
                File file = new File(filePath);
                boolean exist = file.exists();
                if (!exist) {
                    file.getParentFile().mkdirs();
                }
            }
        });
        cfg.setFileOutConfigList(focList);
        mpg.setCfg(cfg);
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setXml(null);
        templateConfig.setServiceImpl(serviceImplTemplatePath);
        templateConfig.setController(null);
        mpg.setTemplate(templateConfig);
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setEntityTableFieldAnnotationEnable(true);
        strategy.setInclude(new String[]{table.name});
        mpg.setStrategy(strategy);
        mpg.execute();
    }

    public static final class GeneratorTable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String schema;
        @XStreamAsAttribute
        private String author;
        @XStreamAsAttribute
        private String name;
        @XStreamAsAttribute
        private String idType;
        @XStreamAsAttribute
        @XStreamAlias(value="cover-entity")
        private boolean coverEntity;

        public String getSchema() {
            return this.schema;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getName() {
            return this.name;
        }

        public String getIdType() {
            return this.idType;
        }

        public boolean isCoverEntity() {
            return this.coverEntity;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIdType(String idType) {
            this.idType = idType;
        }

        public void setCoverEntity(boolean coverEntity) {
            this.coverEntity = coverEntity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorTable)) {
                return false;
            }
            GeneratorTable other = (GeneratorTable)o;
            if (this.isCoverEntity() != other.isCoverEntity()) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$idType = this.getIdType();
            String other$idType = other.getIdType();
            return !(this$idType == null ? other$idType != null : !this$idType.equals(other$idType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCoverEntity() ? 79 : 97);
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $idType = this.getIdType();
            result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorTable(schema=" + this.getSchema() + ", author=" + this.getAuthor() + ", name=" + this.getName() + ", idType=" + this.getIdType() + ", coverEntity=" + this.isCoverEntity() + ")";
        }
    }

    public static final class GeneratorModule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String name;
        @XStreamAsAttribute
        @XStreamAlias(value="package")
        private String pkg;
        @XStreamImplicit(itemFieldName="table")
        private List<GeneratorTable> tables;

        public String getName() {
            return this.name;
        }

        public String getPkg() {
            return this.pkg;
        }

        public List<GeneratorTable> getTables() {
            return this.tables;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public void setTables(List<GeneratorTable> tables) {
            this.tables = tables;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorModule)) {
                return false;
            }
            GeneratorModule other = (GeneratorModule)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$pkg = this.getPkg();
            String other$pkg = other.getPkg();
            if (this$pkg == null ? other$pkg != null : !this$pkg.equals(other$pkg)) {
                return false;
            }
            List<GeneratorTable> this$tables = this.getTables();
            List<GeneratorTable> other$tables = other.getTables();
            return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $pkg = this.getPkg();
            result = result * 59 + ($pkg == null ? 43 : $pkg.hashCode());
            List<GeneratorTable> $tables = this.getTables();
            result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorModule(name=" + this.getName() + ", pkg=" + this.getPkg() + ", tables=" + this.getTables() + ")";
        }
    }

    @XStreamAlias(value="generator")
    public static final class GeneratorConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @XStreamAsAttribute
        private String dsName;
        private String url;
        private String username;
        private String password;
        private String driverName;
        @XStreamImplicit(itemFieldName="module")
        private List<GeneratorModule> modules;

        public String getDsName() {
            return this.dsName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getDriverName() {
            return this.driverName;
        }

        public List<GeneratorModule> getModules() {
            return this.modules;
        }

        public void setDsName(String dsName) {
            this.dsName = dsName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setDriverName(String driverName) {
            this.driverName = driverName;
        }

        public void setModules(List<GeneratorModule> modules) {
            this.modules = modules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeneratorConfig)) {
                return false;
            }
            GeneratorConfig other = (GeneratorConfig)o;
            String this$dsName = this.getDsName();
            String other$dsName = other.getDsName();
            if (this$dsName == null ? other$dsName != null : !this$dsName.equals(other$dsName)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$driverName = this.getDriverName();
            String other$driverName = other.getDriverName();
            if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
                return false;
            }
            List<GeneratorModule> this$modules = this.getModules();
            List<GeneratorModule> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dsName = this.getDsName();
            result = result * 59 + ($dsName == null ? 43 : $dsName.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $driverName = this.getDriverName();
            result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
            List<GeneratorModule> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        public String toString() {
            return "MyGeneratorUtil.GeneratorConfig(dsName=" + this.getDsName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverName=" + this.getDriverName() + ", modules=" + this.getModules() + ")";
        }
    }
}

