/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.MyExcel.config.MyColumn;
import cn.renlm.plugins.MyExcel.config.column.Annotation;
import cn.renlm.plugins.MyExcel.config.column.Dict;
import cn.renlm.plugins.MyExcel.entity.CellUnit;
import cn.renlm.plugins.MyExcel.util.MergeUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public final class StyleUtil {
    public static final void createTitleAnnotation(Workbook wb, Sheet sh, int startRow, List<Map<String, CellUnit>> fieldTitles) {
        int i = 0;
        int level = fieldTitles.size();
        int lastTitleRow = startRow + level - 1;
        for (Map<String, CellUnit> row : fieldTitles) {
            if (++i > 1) break;
            AtomicInteger colIdx = new AtomicInteger(0);
            for (Map.Entry<String, CellUnit> entry : row.entrySet()) {
                int colNum = colIdx.getAndIncrement();
                CellUnit cellUnit = entry.getValue();
                MyColumn column = cellUnit.getColumn();
                Annotation annotation = column.getAnnotation();
                if (annotation == null || !StrUtil.isNotBlank((CharSequence)annotation.getText())) continue;
                Cell cell = MergeUtil.findFirstCellOfUnitRegion(sh, lastTitleRow, colNum);
                int col1 = cell.getColumnIndex();
                int row1 = cell.getRowIndex();
                int col2 = col1 + 3;
                int row2 = row1 + Math.max(level, 4);
                Drawing draw = sh.createDrawingPatriarch();
                Comment comment = draw.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, col1, row1, col2, row2));
                XSSFRichTextString rtf = new XSSFRichTextString(annotation.getText());
                Font commentFormatter = wb.createFont();
                commentFormatter.setFontName("SimSun");
                commentFormatter.setFontHeightInPoints((short)10);
                rtf.applyFont(commentFormatter);
                comment.setString((RichTextString)rtf);
                cell.setCellComment(comment);
            }
        }
    }

    public static final void createDataValidation(Sheet sh, int startRow, List<Map<String, CellUnit>> fieldTitles) {
        int i = 0;
        int level = fieldTitles.size();
        int dataPos = startRow + level - 1;
        for (Map<String, CellUnit> row : fieldTitles) {
            if (++i > 1) break;
            AtomicInteger colIdx = new AtomicInteger(0);
            for (Map.Entry<String, CellUnit> entry : row.entrySet()) {
                List<String> items;
                int colNum = colIdx.getAndIncrement();
                CellUnit cellUnit = entry.getValue();
                MyColumn column = cellUnit.getColumn();
                Dict dict = column.getDict();
                if (dict == null || dict.getItems().size() <= 0 || (items = dict.getItems().stream().map(it -> {
                    if (dict.getType() == Dict.DictType.key) {
                        return it.getKey();
                    }
                    return it.getValue();
                }).filter(it -> StrUtil.isNotBlank((CharSequence)it)).distinct().collect(Collectors.toList())).size() <= 0) continue;
                CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(dataPos, 65535, colNum, colNum);
                DataValidationHelper helper = sh.getDataValidationHelper();
                DataValidationConstraint constraint = helper.createExplicitListConstraint(items.toArray(new String[items.size()]));
                DataValidation dataValidation = helper.createValidation(constraint, cellRangeAddressList);
                dataValidation.setEmptyCellAllowed(true);
                if (dict.isForceCheck()) {
                    dataValidation.setShowPromptBox(true);
                    dataValidation.createPromptBox("\u63d0\u793a", "\u8bf7\u4ece\u4e0b\u62c9\u6846\u91cc\u9009\u62e9\u6570\u636e");
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                }
                sh.addValidationData(dataValidation);
            }
        }
    }

    public static final void autoSizeColumn(SXSSFSheet sh, List<Map<String, CellUnit>> fieldTitles) {
        int i = 0;
        sh.trackAllColumnsForAutoSizing();
        for (Map<String, CellUnit> row : fieldTitles) {
            if (++i > 1) break;
            AtomicInteger colIdx = new AtomicInteger(0);
            row.forEach((field, cellUnit) -> {
                int colNum = colIdx.getAndIncrement();
                MyColumn column = cellUnit.getColumn();
                sh.autoSizeColumn(colNum, true);
                int width = ArrayUtil.max((int[])new int[]{2048, column.getWidth256() * 256, sh.getColumnWidth(colNum) + 256});
                sh.setColumnWidth(colNum, ArrayUtil.min((int[])new int[]{width, 16384}));
            });
        }
    }

    public static final CellStyle createCellStyleWithBorder(Workbook wb, String fontName, short fontSize, Boolean isBold, HorizontalAlignment align) {
        CellStyle cellStyle = wb.createCellStyle();
        Font font = wb.createFont();
        font.setFontName(fontName);
        font.setFontHeightInPoints(fontSize);
        font.setBold(isBold == null ? false : isBold);
        cellStyle.setFont(font);
        cellStyle.setAlignment(align == null ? HorizontalAlignment.LEFT : align);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        return cellStyle;
    }

    private StyleUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

