/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins;

import cn.renlm.plugins.MyCrawler.MySite;
import cn.renlm.plugins.MyCrawler.MySpider;
import cn.renlm.plugins.MyCrawler.data.MyProcessPage;
import cn.renlm.plugins.MyCrawler.data.MyProcessPipe;
import cn.renlm.plugins.MyCrawler.process.MyPageProcessor;
import cn.renlm.plugins.MyCrawler.process.MyPipeline;
import redis.clients.jedis.JedisPool;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.scheduler.RedisScheduler;
import us.codecraft.webmagic.scheduler.Scheduler;

public final class MyCrawlerUtil {
    public static final MySpider createSpider(MySite site, MyPageProcessor pageProcessor, MyPipeline ... pipelines) {
        MySpider mySpider = new MySpider(MyCrawlerUtil.createPageProcessor(site, pageProcessor));
        for (MyPipeline pipeline : pipelines) {
            mySpider.addPipeline(MyCrawlerUtil.createPipeline(site, pipeline));
        }
        return mySpider;
    }

    public static final MySpider createSpider(JedisPool pool, MySite site, MyPageProcessor pageProcessor, MyPipeline ... pipelines) {
        MySpider mySpider = new MySpider(MyCrawlerUtil.createPageProcessor(site, pageProcessor));
        mySpider.setScheduler((Scheduler)new RedisScheduler(pool));
        for (MyPipeline pipeline : pipelines) {
            mySpider.addPipeline(MyCrawlerUtil.createPipeline(site, pipeline));
        }
        return mySpider;
    }

    private static final PageProcessor createPageProcessor(final MySite site, final MyPageProcessor pageProcessor) {
        return new PageProcessor(){

            public void process(Page page) {
                MyProcessPage myPage = new MyProcessPage(site, page);
                pageProcessor.process(myPage);
            }

            public Site getSite() {
                return site;
            }
        };
    }

    private static final Pipeline createPipeline(final MySite site, final MyPipeline pipeline) {
        return new Pipeline(){

            public void process(ResultItems resultItems, Task task) {
                MyProcessPipe myData = new MyProcessPipe(task.getUUID(), site, resultItems);
                pipeline.process(myData);
            }
        };
    }

    private MyCrawlerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

