/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyExcel.config;

import cn.hutool.core.util.StrUtil;
import cn.renlm.plugins.MyExcel.config.column.Alias;
import cn.renlm.plugins.MyExcel.config.column.Annotation;
import cn.renlm.plugins.MyExcel.config.column.Dict;
import cn.renlm.plugins.MyExcel.config.column.Title;
import cn.renlm.plugins.MyExcel.util.StyleUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.io.Serializable;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class MyColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamAlias(value="title")
    private Title title;
    @XStreamImplicit(itemFieldName="alias")
    private List<Alias> aliasList;
    @XStreamAlias(value="annotation")
    private Annotation annotation;
    @XStreamAlias(value="dict")
    private Dict dict;
    @XStreamAsAttribute
    private String field;
    @XStreamAsAttribute
    private String prefix;
    @XStreamAsAttribute
    private String suffix;
    @XStreamAsAttribute
    @XStreamAlias(value="number-format")
    private String numberFormat;
    @XStreamAsAttribute
    @XStreamAlias(value="date-format")
    private String dateFormat;
    @XStreamAsAttribute
    @XStreamAlias(value="not-null")
    private boolean notNull = false;
    @XStreamAsAttribute
    private boolean ignore = false;
    @XStreamAsAttribute
    private boolean optional = false;
    @XStreamAsAttribute
    private int width256;
    @XStreamAsAttribute
    @XStreamConverter(value=HorizontalAlignmentConverter.class)
    private HorizontalAlignment align;
    private CellStyle cellStyle;

    public HorizontalAlignment getAlign() {
        if (StrUtil.isNotBlank((CharSequence)this.numberFormat) || StrUtil.isNotBlank((CharSequence)this.getDateFormat())) {
            this.align = HorizontalAlignment.RIGHT;
        }
        return this.align;
    }

    public CellStyle getCellStyle(Workbook wb) {
        if (this.cellStyle == null) {
            this.cellStyle = StyleUtil.createCellStyleWithBorder(wb, "SimSun", (short)10, false, this.getAlign());
        }
        return this.cellStyle;
    }

    public Title getTitle() {
        return this.title;
    }

    public List<Alias> getAliasList() {
        return this.aliasList;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Dict getDict() {
        return this.dict;
    }

    public String getField() {
        return this.field;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getWidth256() {
        return this.width256;
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public void setAliasList(List<Alias> aliasList) {
        this.aliasList = aliasList;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public void setDict(Dict dict) {
        this.dict = dict;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setWidth256(int width256) {
        this.width256 = width256;
    }

    public void setAlign(HorizontalAlignment align) {
        this.align = align;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyColumn)) {
            return false;
        }
        MyColumn other = (MyColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.isIgnore() != other.isIgnore()) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        if (this.getWidth256() != other.getWidth256()) {
            return false;
        }
        Title this$title = this.getTitle();
        Title other$title = other.getTitle();
        if (this$title == null ? other$title != null : !((Object)this$title).equals(other$title)) {
            return false;
        }
        List<Alias> this$aliasList = this.getAliasList();
        List<Alias> other$aliasList = other.getAliasList();
        if (this$aliasList == null ? other$aliasList != null : !((Object)this$aliasList).equals(other$aliasList)) {
            return false;
        }
        Annotation this$annotation = this.getAnnotation();
        Annotation other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !((Object)this$annotation).equals(other$annotation)) {
            return false;
        }
        Dict this$dict = this.getDict();
        Dict other$dict = other.getDict();
        if (this$dict == null ? other$dict != null : !((Object)this$dict).equals(other$dict)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        String this$numberFormat = this.getNumberFormat();
        String other$numberFormat = other.getNumberFormat();
        if (this$numberFormat == null ? other$numberFormat != null : !this$numberFormat.equals(other$numberFormat)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        HorizontalAlignment this$align = this.getAlign();
        HorizontalAlignment other$align = other.getAlign();
        if (this$align == null ? other$align != null : !this$align.equals(other$align)) {
            return false;
        }
        CellStyle this$cellStyle = this.getCellStyle();
        CellStyle other$cellStyle = other.getCellStyle();
        return !(this$cellStyle == null ? other$cellStyle != null : !this$cellStyle.equals(other$cellStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MyColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + (this.isIgnore() ? 79 : 97);
        result = result * 59 + (this.isOptional() ? 79 : 97);
        result = result * 59 + this.getWidth256();
        Title $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : ((Object)$title).hashCode());
        List<Alias> $aliasList = this.getAliasList();
        result = result * 59 + ($aliasList == null ? 43 : ((Object)$aliasList).hashCode());
        Annotation $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 43 : ((Object)$annotation).hashCode());
        Dict $dict = this.getDict();
        result = result * 59 + ($dict == null ? 43 : ((Object)$dict).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        String $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : $numberFormat.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        HorizontalAlignment $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : $align.hashCode());
        CellStyle $cellStyle = this.getCellStyle();
        result = result * 59 + ($cellStyle == null ? 43 : $cellStyle.hashCode());
        return result;
    }

    public String toString() {
        return "MyColumn(title=" + this.getTitle() + ", aliasList=" + this.getAliasList() + ", annotation=" + this.getAnnotation() + ", dict=" + this.getDict() + ", field=" + this.getField() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", numberFormat=" + this.getNumberFormat() + ", dateFormat=" + this.getDateFormat() + ", notNull=" + this.isNotNull() + ", ignore=" + this.isIgnore() + ", optional=" + this.isOptional() + ", width256=" + this.getWidth256() + ", align=" + this.getAlign() + ", cellStyle=" + this.getCellStyle() + ")";
    }

    public static final class HorizontalAlignmentConverter
    implements SingleValueConverter {
        public boolean canConvert(Class type) {
            return type == HorizontalAlignment.class;
        }

        public String toString(Object obj) {
            HorizontalAlignment align = (HorizontalAlignment)obj;
            return align.name().toLowerCase();
        }

        public Object fromString(String str) {
            for (HorizontalAlignment align : HorizontalAlignment.values()) {
                if (!align.name().toLowerCase().equals(str)) continue;
                return align;
            }
            return null;
        }
    }
}

