/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyUtil;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ReUtil;
import cn.hutool.http.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;

public final class MyFontDecryptUtil {
    public static final String REGEX = "&#(\\d{6});";

    public static final CmapLookup getUnicodeCmapLookupFromTTF(String url) {
        return MyFontDecryptUtil.getUnicodeCmapLookupFromTTF(HttpUtil.downloadBytes((String)url));
    }

    public static final CmapLookup getUnicodeCmapLookupFromTTF(byte[] bytes) {
        CmapLookup cmapLookup;
        block6: {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                cmapLookup = MyFontDecryptUtil.getUnicodeCmapLookupFromTTF(in);
                if (Collections.singletonList(in).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(in).get(0) != null) {
                    ((InputStream)in).close();
                }
                throw throwable;
            }
            ((InputStream)in).close();
        }
        return cmapLookup;
    }

    public static final CmapLookup getUnicodeCmapLookupFromTTF(InputStream in) {
        CmapLookup cmapLookup;
        block6: {
            TrueTypeFont font = new TTFParser().parse(in);
            try {
                cmapLookup = font.getUnicodeCmapLookup();
                if (Collections.singletonList(font).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(font).get(0) != null) {
                    font.close();
                }
                throw throwable;
            }
            font.close();
        }
        return cmapLookup;
    }

    public static final String fetchFromGlyphCode(Dict gmap, CmapLookup cmap, String glyphCodes) {
        StringBuffer buff = new StringBuffer();
        List codes = ReUtil.findAll((String)REGEX, (CharSequence)glyphCodes, (int)1);
        for (String code : codes) {
            int glyphId = cmap.getGlyphId(Integer.valueOf(code).intValue());
            buff.append(gmap.get((Object)String.valueOf(glyphId)));
        }
        return buff.toString();
    }

    private MyFontDecryptUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

