/*
 * Decompiled with CFR 0.152.
 */
package cn.renlm.plugins.MyCrawler;

import cn.edu.hfut.dmic.webcollector.model.CrawlDatum;
import cn.edu.hfut.dmic.webcollector.plugin.net.OkHttpRequester;
import cn.hutool.core.util.StrUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerRequester
extends OkHttpRequester {
    private static final Logger log = LoggerFactory.getLogger(CrawlerRequester.class);
    private String Accept;
    private String AcceptEncoding;
    private String AcceptLanguage;
    private String CacheControl;
    private String Connection;
    private String ContentType;
    private String Cookie;
    private String Host;
    private String Origin;
    private String Pragma;
    private String Referer;
    private String UpgradeInsecureRequests;
    private String UserAgent;
    private String XRequestedWith;
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    public CrawlerRequester build(String key, String value) {
        this.map.put(key, value);
        return this;
    }

    public Request.Builder createRequestBuilder(CrawlDatum crawlDatum) {
        MultipartBody.Builder body = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            body.addFormDataPart(entry.getKey(), entry.getValue());
        }
        log.debug("\u722c\u866b\u8bf7\u6c42\uff1a" + crawlDatum.url());
        Request.Builder builder = super.createRequestBuilder(crawlDatum).header("Cache-Control", "no-cache").header("Connection", "keep-alive").header("Pragma", "no-cache").header("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36");
        if (StrUtil.isNotBlank((CharSequence)this.Accept)) {
            builder.header("Accept", this.Accept);
        }
        if (StrUtil.isNotBlank((CharSequence)this.AcceptEncoding)) {
            builder.header("Accept-Encoding", this.AcceptEncoding);
        }
        if (StrUtil.isNotBlank((CharSequence)this.AcceptLanguage)) {
            builder.header("Accept-Language", this.AcceptLanguage);
        }
        if (StrUtil.isNotBlank((CharSequence)this.CacheControl)) {
            builder.header("Cache-Control", this.CacheControl);
        }
        if (StrUtil.isNotBlank((CharSequence)this.Connection)) {
            builder.header("Connection", this.Connection);
        }
        if (StrUtil.isNotBlank((CharSequence)this.ContentType)) {
            builder.header("Content-Type", this.ContentType);
        }
        if (StrUtil.isNotBlank((CharSequence)this.Cookie)) {
            builder.header("Cookie", this.Cookie);
        }
        if (StrUtil.isNotBlank((CharSequence)this.Host)) {
            builder.header("Host", this.Host);
        }
        if (StrUtil.isNotBlank((CharSequence)this.Origin)) {
            builder.header("Origin", this.Origin);
        }
        if (StrUtil.isNotBlank((CharSequence)this.Pragma)) {
            builder.header("Pragma", this.Pragma);
        }
        if (StrUtil.isNotBlank((CharSequence)this.Referer)) {
            builder.header("Referer", this.Referer);
        }
        if (StrUtil.isNotBlank((CharSequence)this.UpgradeInsecureRequests)) {
            builder.header("Upgrade-Insecure-Requests", this.UpgradeInsecureRequests);
        }
        if (StrUtil.isNotBlank((CharSequence)this.UserAgent)) {
            builder.header("User-Agent", this.UserAgent);
        }
        if (StrUtil.isNotBlank((CharSequence)this.XRequestedWith)) {
            builder.header("X-Requested-With", this.XRequestedWith);
        }
        if (this.map.size() == 0) {
            return builder;
        }
        MultipartBody reqBody = body.build();
        builder.header("Content-Length", String.valueOf(reqBody.contentLength()));
        return builder.post((RequestBody)reqBody);
    }

    public String getAccept() {
        return this.Accept;
    }

    public String getAcceptEncoding() {
        return this.AcceptEncoding;
    }

    public String getAcceptLanguage() {
        return this.AcceptLanguage;
    }

    public String getCacheControl() {
        return this.CacheControl;
    }

    public String getConnection() {
        return this.Connection;
    }

    public String getContentType() {
        return this.ContentType;
    }

    public String getCookie() {
        return this.Cookie;
    }

    public String getHost() {
        return this.Host;
    }

    public String getOrigin() {
        return this.Origin;
    }

    public String getPragma() {
        return this.Pragma;
    }

    public String getReferer() {
        return this.Referer;
    }

    public String getUpgradeInsecureRequests() {
        return this.UpgradeInsecureRequests;
    }

    public String getUserAgent() {
        return this.UserAgent;
    }

    public String getXRequestedWith() {
        return this.XRequestedWith;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public CrawlerRequester setAccept(String Accept) {
        this.Accept = Accept;
        return this;
    }

    public CrawlerRequester setAcceptEncoding(String AcceptEncoding) {
        this.AcceptEncoding = AcceptEncoding;
        return this;
    }

    public CrawlerRequester setAcceptLanguage(String AcceptLanguage) {
        this.AcceptLanguage = AcceptLanguage;
        return this;
    }

    public CrawlerRequester setCacheControl(String CacheControl) {
        this.CacheControl = CacheControl;
        return this;
    }

    public CrawlerRequester setConnection(String Connection) {
        this.Connection = Connection;
        return this;
    }

    public CrawlerRequester setContentType(String ContentType) {
        this.ContentType = ContentType;
        return this;
    }

    public CrawlerRequester setCookie(String Cookie) {
        this.Cookie = Cookie;
        return this;
    }

    public CrawlerRequester setHost(String Host) {
        this.Host = Host;
        return this;
    }

    public CrawlerRequester setOrigin(String Origin) {
        this.Origin = Origin;
        return this;
    }

    public CrawlerRequester setPragma(String Pragma) {
        this.Pragma = Pragma;
        return this;
    }

    public CrawlerRequester setReferer(String Referer) {
        this.Referer = Referer;
        return this;
    }

    public CrawlerRequester setUpgradeInsecureRequests(String UpgradeInsecureRequests) {
        this.UpgradeInsecureRequests = UpgradeInsecureRequests;
        return this;
    }

    public CrawlerRequester setUserAgent(String UserAgent) {
        this.UserAgent = UserAgent;
        return this;
    }

    public CrawlerRequester setXRequestedWith(String XRequestedWith) {
        this.XRequestedWith = XRequestedWith;
        return this;
    }

    public String toString() {
        return "CrawlerRequester(Accept=" + this.getAccept() + ", AcceptEncoding=" + this.getAcceptEncoding() + ", AcceptLanguage=" + this.getAcceptLanguage() + ", CacheControl=" + this.getCacheControl() + ", Connection=" + this.getConnection() + ", ContentType=" + this.getContentType() + ", Cookie=" + this.getCookie() + ", Host=" + this.getHost() + ", Origin=" + this.getOrigin() + ", Pragma=" + this.getPragma() + ", Referer=" + this.getReferer() + ", UpgradeInsecureRequests=" + this.getUpgradeInsecureRequests() + ", UserAgent=" + this.getUserAgent() + ", XRequestedWith=" + this.getXRequestedWith() + ", map=" + this.getMap() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrawlerRequester)) {
            return false;
        }
        CrawlerRequester other = (CrawlerRequester)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$Accept = this.getAccept();
        String other$Accept = other.getAccept();
        if (this$Accept == null ? other$Accept != null : !this$Accept.equals(other$Accept)) {
            return false;
        }
        String this$AcceptEncoding = this.getAcceptEncoding();
        String other$AcceptEncoding = other.getAcceptEncoding();
        if (this$AcceptEncoding == null ? other$AcceptEncoding != null : !this$AcceptEncoding.equals(other$AcceptEncoding)) {
            return false;
        }
        String this$AcceptLanguage = this.getAcceptLanguage();
        String other$AcceptLanguage = other.getAcceptLanguage();
        if (this$AcceptLanguage == null ? other$AcceptLanguage != null : !this$AcceptLanguage.equals(other$AcceptLanguage)) {
            return false;
        }
        String this$CacheControl = this.getCacheControl();
        String other$CacheControl = other.getCacheControl();
        if (this$CacheControl == null ? other$CacheControl != null : !this$CacheControl.equals(other$CacheControl)) {
            return false;
        }
        String this$Connection = this.getConnection();
        String other$Connection = other.getConnection();
        if (this$Connection == null ? other$Connection != null : !this$Connection.equals(other$Connection)) {
            return false;
        }
        String this$ContentType = this.getContentType();
        String other$ContentType = other.getContentType();
        if (this$ContentType == null ? other$ContentType != null : !this$ContentType.equals(other$ContentType)) {
            return false;
        }
        String this$Cookie = this.getCookie();
        String other$Cookie = other.getCookie();
        if (this$Cookie == null ? other$Cookie != null : !this$Cookie.equals(other$Cookie)) {
            return false;
        }
        String this$Host = this.getHost();
        String other$Host = other.getHost();
        if (this$Host == null ? other$Host != null : !this$Host.equals(other$Host)) {
            return false;
        }
        String this$Origin = this.getOrigin();
        String other$Origin = other.getOrigin();
        if (this$Origin == null ? other$Origin != null : !this$Origin.equals(other$Origin)) {
            return false;
        }
        String this$Pragma = this.getPragma();
        String other$Pragma = other.getPragma();
        if (this$Pragma == null ? other$Pragma != null : !this$Pragma.equals(other$Pragma)) {
            return false;
        }
        String this$Referer = this.getReferer();
        String other$Referer = other.getReferer();
        if (this$Referer == null ? other$Referer != null : !this$Referer.equals(other$Referer)) {
            return false;
        }
        String this$UpgradeInsecureRequests = this.getUpgradeInsecureRequests();
        String other$UpgradeInsecureRequests = other.getUpgradeInsecureRequests();
        if (this$UpgradeInsecureRequests == null ? other$UpgradeInsecureRequests != null : !this$UpgradeInsecureRequests.equals(other$UpgradeInsecureRequests)) {
            return false;
        }
        String this$UserAgent = this.getUserAgent();
        String other$UserAgent = other.getUserAgent();
        if (this$UserAgent == null ? other$UserAgent != null : !this$UserAgent.equals(other$UserAgent)) {
            return false;
        }
        String this$XRequestedWith = this.getXRequestedWith();
        String other$XRequestedWith = other.getXRequestedWith();
        if (this$XRequestedWith == null ? other$XRequestedWith != null : !this$XRequestedWith.equals(other$XRequestedWith)) {
            return false;
        }
        Map<String, String> this$map = this.getMap();
        Map<String, String> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !((Object)this$map).equals(other$map));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CrawlerRequester;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $Accept = this.getAccept();
        result = result * 59 + ($Accept == null ? 43 : $Accept.hashCode());
        String $AcceptEncoding = this.getAcceptEncoding();
        result = result * 59 + ($AcceptEncoding == null ? 43 : $AcceptEncoding.hashCode());
        String $AcceptLanguage = this.getAcceptLanguage();
        result = result * 59 + ($AcceptLanguage == null ? 43 : $AcceptLanguage.hashCode());
        String $CacheControl = this.getCacheControl();
        result = result * 59 + ($CacheControl == null ? 43 : $CacheControl.hashCode());
        String $Connection = this.getConnection();
        result = result * 59 + ($Connection == null ? 43 : $Connection.hashCode());
        String $ContentType = this.getContentType();
        result = result * 59 + ($ContentType == null ? 43 : $ContentType.hashCode());
        String $Cookie = this.getCookie();
        result = result * 59 + ($Cookie == null ? 43 : $Cookie.hashCode());
        String $Host = this.getHost();
        result = result * 59 + ($Host == null ? 43 : $Host.hashCode());
        String $Origin = this.getOrigin();
        result = result * 59 + ($Origin == null ? 43 : $Origin.hashCode());
        String $Pragma = this.getPragma();
        result = result * 59 + ($Pragma == null ? 43 : $Pragma.hashCode());
        String $Referer = this.getReferer();
        result = result * 59 + ($Referer == null ? 43 : $Referer.hashCode());
        String $UpgradeInsecureRequests = this.getUpgradeInsecureRequests();
        result = result * 59 + ($UpgradeInsecureRequests == null ? 43 : $UpgradeInsecureRequests.hashCode());
        String $UserAgent = this.getUserAgent();
        result = result * 59 + ($UserAgent == null ? 43 : $UserAgent.hashCode());
        String $XRequestedWith = this.getXRequestedWith();
        result = result * 59 + ($XRequestedWith == null ? 43 : $XRequestedWith.hashCode());
        Map<String, String> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : ((Object)$map).hashCode());
        return result;
    }
}

