/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.zookeeper;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.zookeeper.AbstractZooKeeperManager;
import cn.regionsoft.one.zookeeper.CuratorFrameworkWrapper;
import cn.regionsoft.one.zookeeper.StateListener;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.RetryNTimes;

public class ZooKeeperManager
extends AbstractZooKeeperManager {
    private static final Logger logger = Logger.getLogger(ZooKeeperManager.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private final CuratorFramework curatorFramework;
    private CuratorFrameworkWrapper curatorFrameworkWrapper;

    public ZooKeeperManager(String connectStr) {
        this.curatorFramework = CuratorFrameworkFactory.builder().connectString(connectStr).retryPolicy((RetryPolicy)new RetryNTimes(3, 1000)).sessionTimeoutMs(5000).connectionTimeoutMs(5000).build();
        this.curatorFrameworkWrapper = new CuratorFrameworkWrapper(this.curatorFramework);
        this.setCuratorClient(this.curatorFramework);
        this.curatorFramework.getConnectionStateListenable().addListener((Object)new ConnectionStateListener(){

            public void stateChanged(CuratorFramework client, ConnectionState state) {
                ZooKeeperManager.this.setConnectionState(state);
                switch (state) {
                    case LOST: {
                        ZooKeeperManager.this.triggerState(StateListener.State.DISCONNECTED);
                        break;
                    }
                    case CONNECTED: {
                        ZooKeeperManager.this.triggerState(StateListener.State.CONNECTED);
                        break;
                    }
                    case RECONNECTED: {
                        ZooKeeperManager.this.triggerState(StateListener.State.RECONNECTED);
                        break;
                    }
                }
            }
        });
        try {
            this.curatorFramework.start();
            this.curatorFramework.blockUntilConnected();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public CuratorFrameworkWrapper getCuratorFrameworkWrapper() {
        return this.curatorFrameworkWrapper;
    }

    public void regService(String registryKey, final String serviceEndPoint) {
        try {
            final String observedPath = registryKey;
            if (this.getConnectionState() == ConnectionState.CONNECTED) {
                this.curatorFrameworkWrapper.createPathIfNotExsits(observedPath, false);
                this.curatorFrameworkWrapper.createEphemeralSEQUENTIAL(observedPath + "/", serviceEndPoint);
            }
            this.addStateListener(observedPath, new StateListener(){

                @Override
                public void stateChanged(StateListener.State state) {
                    switch (state) {
                        case CONNECTED: 
                        case RECONNECTED: {
                            ZooKeeperManager.this.curatorFrameworkWrapper.createPathIfNotExsits(observedPath, false);
                            ZooKeeperManager.this.curatorFrameworkWrapper.createEphemeralSEQUENTIAL(observedPath + "/", serviceEndPoint);
                            break;
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

