/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.zookeeper;

import com.google.common.base.Charsets;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundVersionable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;

public class CuratorFrameworkWrapper {
    private CuratorFramework curatorFramework;

    public CuratorFrameworkWrapper(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }

    public void createPathIfNotExsits(String path, boolean ephemeral) {
        int i = path.lastIndexOf(47);
        if (i > 0) {
            this.createPathIfNotExsits(path.substring(0, i), ephemeral);
        }
        if (this.checkExist(path)) {
            return;
        }
        if (ephemeral) {
            this.createEphemeral(path);
        } else {
            this.createPersistent(path);
        }
    }

    public void createrOrUpdate(String path, String content) {
        try {
            this.curatorFramework.setData().forPath(path, content.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createrOrUpdateInTransaction(String path, String content) {
        try {
            this.curatorFramework.inTransaction().setData().forPath(path, content.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createPersistent(String path) {
        try {
            this.curatorFramework.create().forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createEphemeral(String path) {
        try {
            ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL)).forPath(path);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void createEphemeralSEQUENTIAL(String path, String data) {
        try {
            byte[] bytes = data.getBytes();
            ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL_SEQUENTIAL)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(path, bytes);
        }
        catch (KeeperException.NodeExistsException bytes) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void delete(String path, boolean deletingChildrenIfNeeded) {
        try {
            (deletingChildrenIfNeeded ? ((ChildrenDeletable)this.curatorFramework.delete().guaranteed()).deletingChildrenIfNeeded() : (BackgroundVersionable)this.curatorFramework.delete().guaranteed()).forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public List<String> getListChildren(String path) {
        try {
            return (List)this.curatorFramework.getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void getListChildrenAndValues(String path) throws Exception {
        List paths = (List)this.curatorFramework.getChildren().forPath(path);
        for (String p : paths) {
            String data = new String((byte[])this.curatorFramework.getData().forPath(path + "/" + p), Charsets.UTF_8);
            System.out.println(p + "=" + data);
        }
    }

    public boolean checkExist(String path) {
        try {
            return null != this.curatorFramework.checkExists().forPath(path);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String read(String path) throws Exception {
        return new String((byte[])this.curatorFramework.getData().forPath(path), Charsets.UTF_8);
    }
}

