/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.zookeeper;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.zookeeper.StateListener;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.utils.CloseableUtils;

public abstract class AbstractZooKeeperManager {
    private static final Logger logger = Logger.getLogger(AbstractZooKeeperManager.class);
    private final ConcurrentHashMap<String, StateListener> stateListenerPool;
    private final Lock nodeLock = new ReentrantLock();
    private final Lock pathChildrenLock = new ReentrantLock();
    private final Map<String, NodeCache> nodeCachePool;
    private final Map<String, PathChildrenCache> pathChildrenCachePool;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private ConnectionState connectionState = ConnectionState.LOST;
    private CuratorFramework curatorClient;

    public AbstractZooKeeperManager() {
        this.stateListenerPool = new ConcurrentHashMap();
        this.nodeCachePool = Maps.newHashMap();
        this.pathChildrenCachePool = Maps.newHashMap();
        this.addShutdownHook();
    }

    public void setCuratorClient(CuratorFramework curatorClient) {
        this.curatorClient = curatorClient;
    }

    public void addStateListener(String path, StateListener listener) {
        this.stateListenerPool.put(path, listener);
    }

    public void removeStateListener(String path) {
        this.stateListenerPool.remove(path);
    }

    public ConcurrentHashMap<String, StateListener> getStateListeners() {
        return this.stateListenerPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeListener(String path, NodeCacheListener nodeCacheListener) {
        Lock currentLock = this.nodeLock;
        currentLock.lock();
        try {
            if (null == this.nodeCachePool.get(path)) {
                NodeCache nodeCache = new NodeCache(this.curatorClient, path, false);
                nodeCache.getListenable().addListener((Object)nodeCacheListener);
                nodeCache.start();
                this.nodeCachePool.put(path, nodeCache);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodeListener(String path) {
        Lock currentLock = this.nodeLock;
        currentLock.lock();
        try {
            NodeCache nodeCache = this.nodeCachePool.remove(path);
            if (null != nodeCache) {
                nodeCache.close();
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPathChildrenListener(String path, PathChildrenCacheListener pathChildrenCacheListener) {
        Lock currentLock = this.pathChildrenLock;
        currentLock.lock();
        try {
            if (null == this.pathChildrenCachePool.get(path)) {
                PathChildrenCache pathChildrenCache = new PathChildrenCache(this.curatorClient, path, true);
                pathChildrenCache.getListenable().addListener((Object)pathChildrenCacheListener);
                pathChildrenCache.start();
                this.pathChildrenCachePool.put(path, pathChildrenCache);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePathChildrenListener(String path) {
        Lock currentLock = this.pathChildrenLock;
        currentLock.lock();
        try {
            PathChildrenCache pathChildrenCache = this.pathChildrenCachePool.remove(path);
            if (null != pathChildrenCache) {
                pathChildrenCache.close();
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            currentLock.unlock();
        }
    }

    protected void triggerState(StateListener.State state) {
        for (StateListener stateListener : this.getStateListeners().values()) {
            stateListener.stateChanged(state);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractZooKeeperManager.this.close();
            }
        });
    }

    private void close() {
        if (this.closed.get()) {
            return;
        }
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.doClose();
            }
            catch (Throwable t) {
                logger.error(t);
            }
        }
    }

    private void doClose() {
        Iterator<NodeCache> itrator = this.nodeCachePool.values().iterator();
        while (itrator.hasNext()) {
            CloseableUtils.closeQuietly((Closeable)((Closeable)itrator.next()));
        }
        Iterator<PathChildrenCache> itrator2 = this.pathChildrenCachePool.values().iterator();
        while (itrator2.hasNext()) {
            CloseableUtils.closeQuietly((Closeable)((Closeable)itrator2.next()));
        }
        CloseableUtils.closeQuietly((Closeable)this.curatorClient);
    }

    public boolean isConnected() {
        return this.curatorClient.getZookeeperClient().isConnected();
    }

    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }
}

