/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.utils;

import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.H2OConnection;
import cn.regionsoft.one.utils.ThreadContextData;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class ThreadData {
    private HashMap<String, ThreadContextData> threadContextDataMap = new HashMap();
    private SimpleDateFormat simpleDateFormat = null;
    private String previousLocale = null;

    public SimpleDateFormat getSimpleDateFormat(String pattern, String locale) {
        if (this.simpleDateFormat == null || this.previousLocale != locale) {
            if ("en".equalsIgnoreCase(locale)) {
                this.simpleDateFormat = new SimpleDateFormat(pattern, Locale.ENGLISH);
                this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                this.previousLocale = "en";
            } else {
                this.simpleDateFormat = new SimpleDateFormat(pattern, Locale.SIMPLIFIED_CHINESE);
                this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                this.previousLocale = "cn";
            }
        } else {
            this.simpleDateFormat.applyPattern(pattern);
        }
        return this.simpleDateFormat;
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern) {
        if (this.simpleDateFormat == null) {
            this.simpleDateFormat = new SimpleDateFormat(pattern, Locale.ENGLISH);
            this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        } else {
            this.simpleDateFormat.applyPattern(pattern);
        }
        return this.simpleDateFormat;
    }

    public int getTransactionDepth(H2OContext context) {
        return this.getThreadContextData(context).getTransactionDepth();
    }

    public void setTransactionDepth(int transactionDepth, H2OContext context) {
        this.getThreadContextData(context).setTransactionDepth(transactionDepth);
    }

    public int getNonTransactionDepth(H2OContext context) {
        return this.getThreadContextData(context).getNonTransactionDepth();
    }

    public void setNonTransactionDepth(int nonTransactionDepth, H2OContext context) {
        this.getThreadContextData(context).setNonTransactionDepth(nonTransactionDepth);
    }

    public H2OConnection getTransactionConnection(H2OContext context) {
        return this.getThreadContextData(context).getTransactionConnection();
    }

    public void setTransactionConnection(H2OConnection transactionConnection, H2OContext context) {
        this.getThreadContextData(context).setTransactionConnection(transactionConnection);
    }

    public H2OConnection getNoTrxConnection(H2OContext context) {
        return this.getThreadContextData(context).getNoTrxConnection();
    }

    public void setNoTrxConnection(H2OConnection noTrxConnection, H2OContext context) {
        this.getThreadContextData(context).setNoTrxConnection(noTrxConnection);
    }

    ThreadContextData getThreadContextData(H2OContext context) {
        String contextName = context.getContextName();
        ThreadContextData threadContextData = this.threadContextDataMap.get(contextName);
        if (threadContextData == null) {
            threadContextData = new ThreadContextData();
            this.threadContextDataMap.put(contextName, threadContextData);
        }
        return threadContextData;
    }
}

