/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.utils;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicInteger;

public class RingBuffer<T>
implements Serializable {
    private static final long serialVersionUID = 6976960108708949038L;
    private volatile AtomicInteger head = new AtomicInteger(0);
    private volatile AtomicInteger tail = new AtomicInteger(0);
    private int length;
    final T EMPTY = null;
    private volatile T[] queue;

    public RingBuffer(Class<T> type, int length) {
        this.length = length == 0 ? 131072 : length;
        this.queue = (Object[])Array.newInstance(type, this.length);
    }

    public void add(T t) {
        if (t == null) {
            return;
        }
        while (this.getTail() - this.getHead() >= this.length) {
        }
        int ctail = this.tail.getAndIncrement();
        while (this.queue[this.getTail(ctail)] != this.EMPTY) {
        }
        this.queue[this.getTail((int)ctail)] = t;
    }

    public T take() {
        T t = null;
        while (this.head.get() >= this.tail.get()) {
        }
        int chead = this.head.getAndIncrement();
        while (this.queue[this.getHead(chead)] == this.EMPTY) {
        }
        t = this.queue[this.getHead(chead)];
        this.queue[this.getHead((int)chead)] = this.EMPTY;
        return t;
    }

    public int getHead(int index) {
        return index & this.length - 1;
    }

    public int getTail(int index) {
        return index & this.length - 1;
    }

    public int getHead() {
        return this.head.get() & this.length - 1;
    }

    public int getTail() {
        return this.tail.get() & this.length - 1;
    }

    public T[] getQueue() {
        return this.queue;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

