/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.utils;

import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.core.entity.BindObject;
import java.lang.reflect.Field;
import java.util.Collection;
import org.bson.Document;

public class MongoUtil {
    public static final String ID = "_id";

    public static <T> T documentToObject(Document document, BindObject bindObject) throws InstantiationException, IllegalAccessException {
        BindColumn versionColumn;
        if (document == null) {
            return null;
        }
        Object result = bindObject.getEntityClass().newInstance();
        Collection<BindColumn> columns = bindObject.getColumns().values();
        Field field = null;
        for (BindColumn bindColumn : columns) {
            field = bindColumn.getField();
            MongoUtil.setField(result, field, document.get((Object)field.getName()));
        }
        BindColumn idColumn = bindObject.getIdColumn();
        if (idColumn != null) {
            field = idColumn.getField();
            MongoUtil.setField(result, field, document.get((Object)ID));
        }
        if ((versionColumn = bindObject.getVersionColumn()) != null) {
            field = versionColumn.getField();
            MongoUtil.setField(result, field, document.get((Object)field.getName()));
        }
        return (T)result;
    }

    private static void setField(Object result, Field field, Object val) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        if (val == null) {
            field.set(result, val);
            return;
        }
        if (field.getType() != val.getClass()) {
            if (val.getClass() == Long.class && field.getType() == Integer.class) {
                field.set(result, ((Long)val).intValue());
                return;
            }
        } else {
            field.set(result, val);
            return;
        }
        throw new RuntimeException("val type not matched");
    }

    public static <T> Document objectToDocument(T instance, BindObject bindObject) throws IllegalArgumentException, IllegalAccessException {
        BindColumn versionColumn;
        Document document = new Document();
        Collection<BindColumn> columns = bindObject.getColumns().values();
        Field field = null;
        Object value = null;
        for (BindColumn bindColumn : columns) {
            field = bindColumn.getField();
            field.setAccessible(true);
            value = field.get(instance);
            document.append(bindColumn.getName(), value);
        }
        BindColumn idColumn = bindObject.getIdColumn();
        if (idColumn != null) {
            field = idColumn.getField();
            field.setAccessible(true);
            value = field.get(instance);
            document.append(ID, value);
        }
        if ((versionColumn = bindObject.getVersionColumn()) != null) {
            field = versionColumn.getField();
            field.setAccessible(true);
            Integer versionNo = (Integer)field.get(instance);
            versionNo = versionNo == null ? Integer.valueOf(0) : Integer.valueOf(versionNo + 1);
            field.set(instance, versionNo);
            document.append(versionColumn.getName(), value);
        }
        return document;
    }
}

