/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.utils;

import cn.regionsoft.one.common.JsonUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ContextConfig;
import cn.regionsoft.one.core.H2OContext;
import cn.regionsoft.one.core.dbconnection.MongoConnection;
import cn.regionsoft.one.core.entity.BindColumn;
import cn.regionsoft.one.core.entity.BindObject;
import cn.regionsoft.one.data.persistence.criteria.Condition;
import cn.regionsoft.one.data.persistence.criteria.Operator;
import cn.regionsoft.one.data.persistence.criteria.Query;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoHelper {
    private static final String MONGO_ID = "_id";
    private static final String ID = "id";
    private static final Logger logger = Logger.getLogger(MongoHelper.class);
    private static final String LIKE_PREFIX = "^.*";
    private static final String LIKE_SUFFIX = ".*$";
    private static final String GT = "$gt";
    private static final String GTE = "$gte";
    private static final String LT = "$lt";
    private static final String LTE = "$lte";
    private static final String IN = "$in";
    private static final String SPACE = " ";
    private static final String DESC = "desc";
    private static final String ASC = "asc";
    private static final String SET = "$set";
    private static final String AND = "$and";
    private static final String BETWEEN = "between";
    private static final String OR = "or";

    public static MongoCollection<Document> getCollectionByEntity(MongoConnection mongoConnection, Class entityClass) {
        String simpleName = entityClass.getSimpleName();
        return null;
    }

    public static <T> List<T> findAll(Class<T> entityClass) {
        MongoCollection<Document> collection = MongoHelper.getBindCollection(entityClass);
        FindIterable iterables = collection.find();
        MongoCursor cursor = iterables.iterator();
        ArrayList<T> result = new ArrayList<T>();
        while (cursor.hasNext()) {
            Document tmp = (Document)cursor.next();
            T entity = MongoHelper.documentToEntity(tmp, entityClass);
            result.add(entity);
        }
        return result;
    }

    public static <T> void insert(T instance) {
        MongoCollection<Document> collection = MongoHelper.getBindCollection(instance.getClass());
        collection.insertOne((Object)MongoHelper.entityToDocument(instance));
    }

    public static <T, I> T find(I id, Class<T> resultClass) {
        MongoCollection<Document> collection = MongoHelper.getBindCollection(resultClass);
        Query query = new Query();
        query.addCondition(new Condition(MONGO_ID, Operator.EQ, id));
        List<T> ls = MongoHelper.getList(resultClass, collection, query);
        if (ls == null || ls.size() == 0) {
            return null;
        }
        return ls.get(0);
    }

    public static <T, I> void delete(I id, Class<T> entityClass) {
        MongoCollection<Document> collection = MongoHelper.getBindCollection(entityClass);
        BasicDBObject filter = new BasicDBObject();
        filter.put((Object)MONGO_ID, id);
        collection.deleteOne((Bson)filter);
    }

    public static <T, I> void update(I id, T instance, Map<String, BindColumn> dueToUpdateMap) throws IllegalArgumentException, IllegalAccessException {
        MongoCollection<Document> collection = MongoHelper.getBindCollection(instance.getClass());
        BasicDBObject filter = new BasicDBObject();
        filter.put((Object)MONGO_ID, id);
        Document document = new Document();
        Field tmpField = null;
        Object tmpVal = null;
        for (BindColumn bindColumn : dueToUpdateMap.values()) {
            tmpField = bindColumn.getField();
            tmpVal = tmpField.get(instance);
            document.put(bindColumn.getName(), tmpVal);
        }
        collection.updateOne((Bson)filter, (Bson)new Document(SET, (Object)document));
    }

    public static <T, I> void updateMany(Class entityClass, Map<String, Object> filtersValues, Map<String, Object> newValues) throws IllegalArgumentException, IllegalAccessException {
        MongoCollection<Document> collection = MongoHelper.getBindCollection(entityClass);
        BasicDBObject filter = new BasicDBObject();
        for (Map.Entry<String, Object> entry : filtersValues.entrySet()) {
            filter.put((Object)entry.getKey(), entry.getValue());
        }
        Document document = new Document();
        for (Map.Entry<String, Object> entry : newValues.entrySet()) {
            document.put(entry.getKey(), entry.getValue());
        }
        collection.updateMany((Bson)filter, (Bson)new Document(SET, (Object)document));
    }

    public static MongoCollection<Document> getBindCollection(Class entityClass) {
        MongoCollection mongoCollection;
        MongoConnection connection = null;
        try {
            MongoCollection collection;
            H2OContext h2oContext = CommonUtil.getTargetContext(entityClass);
            BindObject bindObject = h2oContext.getEntityManager().getBindObject(entityClass);
            connection = (MongoConnection)h2oContext.getConnectionFromPool();
            ContextConfig config = h2oContext.getConfig();
            MongoDatabase mongoDatabase = connection.getMongoClient().getDatabase(config.getSchema());
            mongoCollection = collection = mongoDatabase.getCollection(bindObject.getTableName());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                CommonUtil.closeQuietly(connection);
                throw throwable;
            }
        }
        CommonUtil.closeQuietly(connection);
        return mongoCollection;
    }

    public static <T> T documentToEntity(Document document, Class<T> classType) {
        try {
            H2OContext h2oContext = CommonUtil.getTargetContext(classType);
            T instance = classType.newInstance();
            Field field = null;
            BindObject bindObject = h2oContext.getEntityManager().getBindObject(instance.getClass());
            if (bindObject.getVersionColumn() != null) {
                field = bindObject.getVersionColumn().getField();
                field.setAccessible(true);
                field.set(instance, document.get((Object)bindObject.getVersionColumn().getName()));
            }
            field = bindObject.getIdColumn().getField();
            field.setAccessible(true);
            field.set(instance, document.get((Object)MONGO_ID));
            for (BindColumn bindColumn : bindObject.getColumns().values()) {
                field = bindColumn.getField();
                field.setAccessible(true);
                List<?> val = document.get((Object)bindColumn.getName());
                if (val instanceof List) {
                    if (bindColumn.getListTypeArgument() == null) {
                        ParameterizedType pt = (ParameterizedType)field.getGenericType();
                        Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
                        bindColumn.setListTypeArgument(actualTypeArgument);
                    }
                    val = JsonUtil.jsonToList(JsonUtil.objectToJson(val), bindColumn.getListTypeArgument());
                    field.set(instance, val);
                    continue;
                }
                field.set(instance, val);
            }
            return instance;
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static <T> Document entityToDocument(Object instance) {
        try {
            Document document = new Document();
            Field field = null;
            H2OContext h2oContext = CommonUtil.getTargetContext(instance.getClass());
            BindObject bindObject = h2oContext.getEntityManager().getBindObject(instance.getClass());
            if (bindObject.getVersionColumn() != null) {
                field = bindObject.getVersionColumn().getField();
                field.setAccessible(true);
                Integer version = (Integer)field.get(instance);
                if (version == null) {
                    version = 1;
                    field.set(instance, version);
                }
                document.put(bindObject.getVersionColumn().getName(), (Object)version);
            }
            field = bindObject.getIdColumn().getField();
            field.setAccessible(true);
            Object id = field.get(instance);
            if (id != null) {
                document.put(MONGO_ID, id);
            }
            Object val = null;
            for (BindColumn bindColumn : bindObject.getColumns().values()) {
                field = bindColumn.getField();
                field.setAccessible(true);
                val = field.get(instance);
                if (val == null) {
                    document.put(bindColumn.getName(), null);
                    continue;
                }
                if (val instanceof List) {
                    document.put(bindColumn.getName(), (Object)BsonArray.parse((String)JsonUtil.objectToJson(val)));
                    continue;
                }
                document.put(bindColumn.getName(), val);
            }
            return document;
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static <T> List<T> getList(Class<T> resultClass, MongoCollection<Document> collection, Query query) {
        return MongoHelper.getList(resultClass, collection, query, null, null, null);
    }

    public static <T> List<T> getList(Class<T> resultClass, MongoCollection<Document> collection, Query query, Integer pageNo, Integer pageSize, String orderBy) {
        BasicDBObject filter = new BasicDBObject();
        MongoHelper.wrapFilter(filter, query.getConditions(), pageNo, pageSize, orderBy);
        FindIterable iterables = collection.find((Bson)filter);
        if (!CommonUtil.isEmpty(orderBy)) {
            BasicDBObject sort = new BasicDBObject();
            String[] array = orderBy.split(SPACE);
            String fieldName = null;
            Integer order = null;
            for (String tmp : array) {
                if (order != null && fieldName != null) break;
                if (tmp.equals(SPACE)) continue;
                if (fieldName == null && order == null) {
                    fieldName = tmp;
                    continue;
                }
                if (tmp.equalsIgnoreCase(DESC)) {
                    order = -1;
                    continue;
                }
                if (!tmp.equalsIgnoreCase(ASC)) break;
                order = 1;
            }
            sort.put(fieldName, (Object)order);
            iterables = iterables.sort((Bson)sort);
        }
        if (pageNo != null && pageSize != null) {
            int fromIndex = (pageNo - 1) * pageSize;
            iterables = iterables.skip(fromIndex).limit(pageSize.intValue());
        }
        MongoCursor cursor = iterables.iterator();
        ArrayList<T> result = new ArrayList<T>();
        while (cursor.hasNext()) {
            Document tmp = (Document)cursor.next();
            T entity = MongoHelper.documentToEntity(tmp, resultClass);
            result.add(entity);
        }
        return result;
    }

    public static long getAmount(MongoCollection<Document> collection, Query query) {
        BasicDBObject filter = new BasicDBObject();
        MongoHelper.wrapFilter(filter, query.getConditions(), null, null, null);
        return collection.count((Bson)filter);
    }

    private static void wrapFilter(BasicDBObject filter, List<Condition> conditions, Integer pageNo, Integer pageSize, String orderBy) {
        if (conditions == null) {
            return;
        }
        for (Condition condition : conditions) {
            if (ID.equals(condition.getFieldName())) {
                condition.setFieldName(MONGO_ID);
            }
            if (condition.getOperator() == Operator.EQ) {
                filter.put((Object)condition.getFieldName(), condition.getVal());
                continue;
            }
            if (condition.getOperator() == Operator.LIKE) {
                Pattern pattern = Pattern.compile(LIKE_PREFIX + condition.getVal() + LIKE_SUFFIX, 2);
                filter.put((Object)condition.getFieldName(), (Object)pattern);
                continue;
            }
            if (condition.getOperator() == Operator.IN) {
                boolean isArray = condition.getVal().getClass().isArray();
                if (isArray) {
                    filter.put((Object)condition.getFieldName(), (Object)new Document(IN, condition.getVal()));
                    continue;
                }
                filter.put((Object)condition.getFieldName(), (Object)new Document(IN, (Object)new Object[]{condition.getVal()}));
                continue;
            }
            if (condition.getOperator() == Operator.GT) {
                filter.put((Object)condition.getFieldName(), (Object)new Document(GT, condition.getVal()));
                continue;
            }
            if (condition.getOperator() == Operator.GTE) {
                filter.put((Object)condition.getFieldName(), (Object)new Document(GTE, condition.getVal()));
                continue;
            }
            if (condition.getOperator() == Operator.LT) {
                filter.put((Object)condition.getFieldName(), (Object)new Document(LT, condition.getVal()));
                continue;
            }
            if (condition.getOperator() != Operator.LTE) continue;
            filter.put((Object)condition.getFieldName(), (Object)new Document(LTE, condition.getVal()));
        }
    }
}

