/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.utils;

import cn.regionsoft.one.common.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class ContextScan {
    private static final Logger logger = Logger.getLogger(ContextScan.class);

    public static HashSet<Class<?>> getClassListByPackage(String basePackage) throws Exception {
        String realPackagePath = basePackage.replaceAll("\\.", "/");
        HashSet classList = new HashSet();
        ContextScan.doScan(realPackagePath, ContextScan.class.getClassLoader(), classList);
        return classList;
    }

    private static void scanByUrl(URL url, String realPackagePath, ClassLoader cl, HashSet<Class<?>> classList) throws Exception {
        String filePath = ContextScan.getRootPath(url);
        List<String> names = null;
        if (filePath.endsWith(".jar")) {
            names = ContextScan.readFromJarFile(filePath, realPackagePath);
            for (String name : names) {
                if (name.endsWith(".class")) {
                    Class<?> tmp = null;
                    try {
                        if (name.indexOf("$") == -1) {
                            tmp = Class.forName(ContextScan.filterClassName(name.replaceAll("/", "\\.")));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        logger.error(e);
                    }
                    if (tmp == null) continue;
                    classList.add(tmp);
                    continue;
                }
                String tmpPath = (realPackagePath + "." + name).replaceAll("\\.", "/");
                ContextScan.doScan(tmpPath, cl, classList);
            }
        } else {
            names = ContextScan.readFromDirectory(filePath);
            for (String name : names) {
                if (name.endsWith(".class")) {
                    Class<?> tmp = ContextScan.toFullyQualifiedName(name, realPackagePath);
                    if (tmp == null) continue;
                    classList.add(tmp);
                    continue;
                }
                String tmpPath = (realPackagePath + "." + name).replaceAll("\\.", "/");
                ContextScan.doScan(tmpPath, cl, classList);
            }
        }
    }

    public static String filterClassName(String nameInJar) {
        return nameInJar.substring(0, nameInJar.length() - 6);
    }

    public static String getRootPath(URL url) {
        String fileUrl = url.getFile();
        int pos = fileUrl.indexOf(33);
        if (-1 == pos) {
            return fileUrl;
        }
        return fileUrl.substring(5, pos);
    }

    private static void doScan(String realPackagePath, ClassLoader cl, HashSet<Class<?>> classList) throws Exception {
        Enumeration<URL> urlLs = cl.getResources(realPackagePath);
        URL url = null;
        while (urlLs.hasMoreElements()) {
            url = urlLs.nextElement();
            ContextScan.scanByUrl(url, realPackagePath, cl, classList);
        }
    }

    private static Class<?> toFullyQualifiedName(String shortName, String basePackage) {
        StringBuilder sb = new StringBuilder(basePackage);
        sb.append('.');
        sb.append(ContextScan.trimExtension(shortName));
        Class<?> result = null;
        try {
            result = Class.forName(sb.toString().replaceAll("/", "\\."));
        }
        catch (ClassNotFoundException e) {
            logger.error(e);
            return null;
        }
        return result;
    }

    private static List<String> readFromJarFile(String jarPath, String splashedPackageName) throws Exception {
        ArrayList<String> classList = new ArrayList<String>();
        try (ZipInputStream jarIn = null;){
            jarIn = new JarInputStream(new FileInputStream(jarPath));
            JarEntry entry = ((JarInputStream)jarIn).getNextJarEntry();
            while (null != entry) {
                String name = entry.getName();
                if (name.startsWith(splashedPackageName) && name.endsWith(".class")) {
                    classList.add(name);
                }
                entry = ((JarInputStream)jarIn).getNextJarEntry();
            }
        }
        return classList;
    }

    private static List<String> readFromDirectory(String path) {
        File file = new File(path);
        String[] names = file.list();
        if (null == names) {
            return null;
        }
        return Arrays.asList(names);
    }

    public static String trimExtension(String name) {
        int pos = name.indexOf(46);
        if (-1 != pos) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String trimURI(String uri) {
        String trimmed = uri.substring(1);
        int splashIndex = trimmed.indexOf(47);
        return trimmed.substring(splashIndex);
    }
}

