/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.tool;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadPool {
    public static ThreadPool threadPool = new ThreadPool();
    private ExecutorService slowTaskExecutor = null;
    private ExecutorService quickTaskExecutor = null;
    private int slowTaskThreadsCount = 50;
    private int quickTaskThreadsCount = Runtime.getRuntime().availableProcessors();

    public ExecutorService getSlowTaskExecutor() {
        return this.slowTaskExecutor;
    }

    public ExecutorService getQuickTaskExecutor() {
        return this.quickTaskExecutor;
    }

    public static ThreadPool getInstance() {
        return threadPool;
    }

    private ThreadPool() {
        this.slowTaskExecutor = Executors.newFixedThreadPool(this.slowTaskThreadsCount);
        this.quickTaskExecutor = Executors.newFixedThreadPool(this.quickTaskThreadsCount);
    }

    public int getSlowTaskThreadsCount() {
        return this.slowTaskThreadsCount;
    }

    public int getQuickTaskThreadsCount() {
        return this.quickTaskThreadsCount;
    }

    public void excuteQuickTask(Runnable runnable) {
        this.quickTaskExecutor.execute(runnable);
    }

    public Future<?> submitQuickTask(Runnable runnable) {
        return this.quickTaskExecutor.submit(runnable);
    }

    public <T> Future<T> submitQuickTask(Callable<T> task) {
        return this.quickTaskExecutor.submit(task);
    }

    public void excuteSlowTask(Runnable runnable) {
        this.slowTaskExecutor.execute(runnable);
    }

    public Future<?> submitSlowTask(Runnable runnable) {
        return this.slowTaskExecutor.submit(runnable);
    }

    public <T> Future<T> submitSlowTask(Callable<T> task) {
        return this.slowTaskExecutor.submit(task);
    }
}

