/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.systemcommand;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.systemcommand.CommandListener;
import cn.regionsoft.one.systemcommand.CommandLogReaderTask;
import cn.regionsoft.one.tool.ThreadPool;
import java.util.ArrayList;
import java.util.List;

public class SystemCommand {
    private static final Logger logger = Logger.getLogger(SystemCommand.class);
    volatile boolean completed = false;
    private StringBuilder commandLogs = new StringBuilder();
    private String lcommand;
    private boolean processExitWithError = false;
    private List<CommandListener> commandListenerList = null;
    private Long timeout = -1L;

    public SystemCommand(String[] commands) {
        StringBuilder commandStrBuilder = new StringBuilder();
        for (int i = 0; i < commands.length; ++i) {
            commandStrBuilder.append(commands[i]);
            if (i == commands.length - 1) continue;
            commandStrBuilder.append(" && ");
        }
        this.lcommand = commandStrBuilder.toString();
        logger.debug("run command:" + this.lcommand);
    }

    public void excute() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", this.lcommand});
            CommandLogReaderTask task = new CommandLogReaderTask(this, this.timeout, p);
            ThreadPool.getInstance().submitSlowTask(task);
            p.waitFor();
            if (p.exitValue() != 0) {
                this.processExitWithError = true;
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void appendCommandLog(String log) {
        this.commandLogs.append(log);
        this.commandLogs.append("\r\n");
        if (this.commandListenerList != null) {
            for (CommandListener commandListener : this.commandListenerList) {
                commandListener.onLog(log);
            }
        }
    }

    void finish() {
        if (this.commandListenerList != null) {
            for (CommandListener commandListener : this.commandListenerList) {
                commandListener.onCompleted(this.processExitWithError);
            }
        }
    }

    public void addCommandListener(CommandListener commandListener) {
        if (this.commandListenerList == null) {
            this.commandListenerList = new ArrayList<CommandListener>();
        }
        this.commandListenerList.add(commandListener);
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public StringBuilder getCommandLogs() {
        return this.commandLogs;
    }

    public boolean isProcessExitWithError() {
        return this.processExitWithError;
    }
}

