/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.systemcommand;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.systemcommand.SystemCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class CommandLogReaderTask
implements Runnable {
    private static Logger logger = Logger.getLogger(CommandLogReaderTask.class);
    private InputStream inputStream;
    private InputStream errorStream;
    private SystemCommand systemCommand;
    private Long deadTime;
    private Long timeout;
    private Process process;
    private ThreadHealthMonitor monitor;

    public CommandLogReaderTask(SystemCommand systemCommand, Long timeout, Process process) {
        this.inputStream = process.getInputStream();
        this.errorStream = process.getErrorStream();
        this.systemCommand = systemCommand;
        this.timeout = timeout;
        this.process = process;
        if (timeout != -1L) {
            this.deadTime = System.currentTimeMillis() + timeout;
        }
        this.monitor = new ThreadHealthMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader bs = null;
        BufferedReader bsError = null;
        try {
            bs = new BufferedReader(new InputStreamReader(this.inputStream));
            bsError = new BufferedReader(new InputStreamReader(this.errorStream));
            String line = null;
            String errorLine = null;
            while (true) {
                if (this.timeout != -1L && System.currentTimeMillis() > this.deadTime) {
                    this.systemCommand.appendCommandLog("command timeout for life duration " + this.timeout + " milliseconds");
                    this.process.destroy();
                    break;
                }
                line = bs.readLine();
                this.monitor.setLastReadTime(System.currentTimeMillis());
                if (line != null) {
                    if (line == null) continue;
                    this.systemCommand.appendCommandLog(line);
                    continue;
                }
                errorLine = bsError.readLine();
                if (errorLine != null && errorLine != null) {
                    this.systemCommand.appendCommandLog(errorLine);
                }
                if (this.systemCommand.completed) break;
                Thread.sleep(100L);
            }
            this.systemCommand.finish();
        }
        catch (Exception e) {
            try {
                if (!(e instanceof IOException)) {
                    logger.error(e);
                }
                this.systemCommand.finish();
            }
            catch (Throwable throwable) {
                this.systemCommand.finish();
                CommonUtil.closeQuietly(bs);
                CommonUtil.closeQuietly(bsError);
                CommonUtil.closeQuietly(this.inputStream);
                CommonUtil.closeQuietly(this.errorStream);
                throw throwable;
            }
            CommonUtil.closeQuietly(bs);
            CommonUtil.closeQuietly(bsError);
            CommonUtil.closeQuietly(this.inputStream);
            CommonUtil.closeQuietly(this.errorStream);
        }
        CommonUtil.closeQuietly(bs);
        CommonUtil.closeQuietly(bsError);
        CommonUtil.closeQuietly(this.inputStream);
        CommonUtil.closeQuietly(this.errorStream);
    }

    class ThreadHealthMonitor
    extends Thread {
        private Long lastReadTime;

        ThreadHealthMonitor() {
        }

        public void setLastReadTime(Long lastReadTime) {
            this.lastReadTime = lastReadTime;
        }

        @Override
        public void run() {
            this.lastReadTime = System.currentTimeMillis();
            while (true) {
                if (System.currentTimeMillis() - this.lastReadTime > 10000L) {
                    try {
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        System.err.println("No response from console more than 10 seconds, auto kill the process");
                        CommandLogReaderTask.this.inputStream.close();
                        CommandLogReaderTask.this.process.destroy();
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

