/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone.fileupload;

import cn.regionsoft.one.standalone.fileupload.RegionFileItem;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class UploadResolver {
    private static final String EMPTY_STR = "";
    private static final byte NEW_LINE1 = 13;
    private static final byte NEW_LINE2 = 10;
    private String boundaryStr = null;
    private RegionFileItem fileItem = null;
    private List<RegionFileItem> fileItemLs = new ArrayList<RegionFileItem>();
    private int filePart = 0;
    private boolean isInFileBody = false;
    private String filePath = null;

    public static void main(String[] args) throws Exception {
        UploadResolver fileTest = new UploadResolver();
        String tmpFilePath = "E:/workspace/eclipse-jee-mars-R-win32-x86_64/eclipse/workspace/Morcble/Local/FILES/tmp/3729273749209088";
        List<RegionFileItem> fileItemLs = fileTest.resolveUpload(tmpFilePath);
        fileItemLs.get(0).write(new File("E:/workspace/eclipse-jee-mars-R-win32-x86_64/eclipse/workspace/Morcble/Local/FILES/tmp/11"));
    }

    public List<RegionFileItem> resolveUpload(String tmpFilePath) throws Exception {
        this.filePath = tmpFilePath;
        File file = new File(this.filePath);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            System.out.println(fis.available());
            bis = new BufferedInputStream(fis);
            int amount = -1;
            byte[] buffer = new byte[1024];
            byte[] lineCache = null;
            int lineStart = 0;
            byte[] tmpByte = null;
            int byteIndex = 0;
            byte[] unhandledBytes = null;
            int unhandledLength = 0;
            while ((amount = bis.read(buffer)) != -1) {
                byteIndex += amount;
                lineStart = 0;
                if (unhandledBytes == null) {
                    unhandledLength = amount;
                    unhandledBytes = new byte[amount];
                    System.arraycopy(buffer, 0, unhandledBytes, 0, amount);
                } else {
                    unhandledLength = amount + unhandledBytes.length;
                    tmpByte = new byte[unhandledLength];
                    System.arraycopy(unhandledBytes, 0, tmpByte, 0, unhandledBytes.length);
                    System.arraycopy(buffer, 0, tmpByte, unhandledBytes.length, amount);
                    unhandledBytes = tmpByte;
                }
                for (int x = 0; x < unhandledLength; ++x) {
                    if (unhandledBytes[x] == 13 && x + 1 < unhandledLength && unhandledBytes[x + 1] == 10) {
                        lineCache = new byte[x - lineStart];
                        System.arraycopy(unhandledBytes, lineStart, lineCache, 0, lineCache.length);
                        if (unhandledLength > amount) {
                            this.handleLine(new String(lineCache), byteIndex - unhandledLength + x);
                        } else {
                            this.handleLine(new String(lineCache), byteIndex - amount + x);
                        }
                        lineStart = x + 2;
                    }
                    if (x != unhandledLength - 1) continue;
                    tmpByte = unhandledBytes;
                    if ((unhandledLength -= lineStart) > 2048) {
                        unhandledLength = 2048;
                    }
                    unhandledBytes = new byte[unhandledLength];
                    System.arraycopy(tmpByte, tmpByte.length - unhandledLength, unhandledBytes, 0, unhandledLength);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.fileItemLs;
    }

    private boolean handleLine(String tmpLine, int lineStart) {
        if (this.boundaryStr == null) {
            this.boundaryStr = tmpLine;
            this.fileItem = new RegionFileItem();
            this.fileItem.setFilePath(this.filePath);
            this.filePart = 0;
            return false;
        }
        if (tmpLine.indexOf(this.boundaryStr) != -1) {
            if (this.fileItem != null) {
                this.finishFileItem(this.fileItem);
                this.fileItemLs.add(this.fileItem);
            }
            if (this.isInFileBody) {
                this.fileItem.setFileByteEndIndex(lineStart - this.boundaryStr.getBytes().length - 2);
                this.isInFileBody = false;
            }
            this.fileItem = new RegionFileItem();
            this.fileItem.setFilePath(this.filePath);
            this.filePart = 0;
            return true;
        }
        if (this.filePart == 0) {
            this.fileItem.setContentDisposition(tmpLine);
            this.filePart = 1;
        } else if (this.filePart == 1) {
            if (EMPTY_STR.equals(tmpLine)) {
                this.filePart = 3;
            } else {
                this.fileItem.setContentType(tmpLine);
                this.filePart = 2;
                this.isInFileBody = true;
            }
        } else if (this.filePart == 2) {
            if (EMPTY_STR.equals(tmpLine)) {
                this.filePart = 3;
                this.fileItem.setFileByteStartIndex(lineStart + 2);
            }
        } else if (this.filePart == 3 && this.fileItem.getContentType() == null) {
            this.fileItem.setContent(tmpLine);
        }
        return false;
    }

    private void finishFileItem(RegionFileItem fileItem) {
    }
}

