/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone.fileupload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;

public class RegionFileItem
implements FileItem {
    private static final long serialVersionUID = -658918796242594130L;
    private static final String SEMICOLON = ";";
    private static final String EQUAL = "=";
    private static final String QUOTATION = "\"";
    private static final String EMPTY_STR = "";
    private String contentDisposition = null;
    private String contentType = null;
    private String content = null;
    private int fileByteStartIndex = -1;
    private int fileByteEndIndex = -1;
    private String filePath = null;
    private String fieldName = null;

    public boolean isFile() {
        return this.fileByteEndIndex != -1;
    }

    public String getFieldName() {
        if (!this.isFile() && this.fieldName == null && this.contentDisposition != null) {
            String[] paraPairs = this.contentDisposition.split(SEMICOLON);
            String[] paraArray = null;
            if (paraPairs.length > 0 && (paraArray = paraPairs[1].split(EQUAL)).length > 0) {
                this.fieldName = paraArray[1].trim().replace(QUOTATION, EMPTY_STR);
            }
        }
        return this.fieldName;
    }

    public String getName() {
        if (this.contentDisposition != null) {
            String[] paraPairs = this.contentDisposition.split(SEMICOLON);
            String[] paraArray = null;
            for (String tmp : paraPairs) {
                paraArray = tmp.split(EQUAL);
                if (paraArray.length != 2 || !paraArray[0].trim().equals("filename")) continue;
                return paraArray[1].replace(QUOTATION, EMPTY_STR);
            }
        }
        return null;
    }

    public long getSize() {
        return this.fileByteEndIndex - this.fileByteStartIndex;
    }

    public String getString() {
        return this.content;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getFileByteStartIndex() {
        return this.fileByteStartIndex;
    }

    public void setFileByteStartIndex(int fileByteStartIndex) {
        this.fileByteStartIndex = fileByteStartIndex;
    }

    public int getFileByteEndIndex() {
        return this.fileByteEndIndex;
    }

    public void setFileByteEndIndex(int fileByteEndIndex) {
        this.fileByteEndIndex = fileByteEndIndex;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void write(File destFile) throws Exception {
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        File file = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            file = new File(this.filePath);
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            fos = new FileOutputStream(destFile);
            bos = new BufferedOutputStream(fos);
            byte[] writeBuffer = new byte[1024];
            int fileByteStartIndex = this.getFileByteStartIndex();
            int fileByteEndIndex = this.getFileByteEndIndex();
            int fileLength = fileByteEndIndex - fileByteStartIndex;
            fis.skip(fileByteStartIndex);
            int fullCopyTime = fileLength / writeBuffer.length;
            int restByte = fileLength % writeBuffer.length;
            int index = 1;
            while (fis.read(writeBuffer) != -1) {
                if (index == fullCopyTime + 1) {
                    ((BufferedOutputStream)bos).write(writeBuffer, 0, restByte);
                    break;
                }
                bos.write(writeBuffer);
                ++index;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            file.delete();
        }
    }

    public FileItemHeaders getHeaders() {
        return null;
    }

    public void setHeaders(FileItemHeaders headers) {
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public boolean isInMemory() {
        return false;
    }

    public byte[] get() {
        return null;
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.content.getBytes(), encoding);
    }

    public void delete() {
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public boolean isFormField() {
        return !this.isFile();
    }

    public void setFormField(boolean state) {
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

