/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.SYSEnvSetup;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.standalone.HttpEpollServer;
import cn.regionsoft.one.standalone.HttpNIOServer;
import cn.regionsoft.one.standalone.HttpServer;
import io.netty.channel.epoll.Epoll;
import javax.net.ssl.KeyManagerFactory;

public class StandaloneServer {
    public static String contextPath;

    public StandaloneServer(String contextPath) {
        StandaloneServer.contextPath = contextPath + "/region";
    }

    public void runHttp() {
        try {
            SYSEnvSetup.setUp();
            String portStr = ConfigUtil.getProperty("backend.port");
            if (CommonUtil.isEmpty(portStr)) {
                portStr = "8080";
            }
            HttpServer server = null;
            server = Epoll.isAvailable() ? new HttpEpollServer() : new HttpNIOServer();
            server.start(Integer.parseInt(portStr), contextPath, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void runHttps(KeyManagerFactory keyManagerFactory) {
        try {
            SYSEnvSetup.setUp();
            String portStr = ConfigUtil.getProperty("backend.port");
            if (CommonUtil.isEmpty(portStr)) {
                portStr = "8080";
            }
            HttpServer server = null;
            server = Epoll.isAvailable() ? new HttpEpollServer() : new HttpNIOServer();
            server.start(Integer.parseInt(portStr), contextPath, keyManagerFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        StandaloneServer a = new StandaloneServer("123");
    }
}

