/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class RegionHttpResponse
implements HttpServletResponse {
    private List<Cookie> cookieLs = null;
    private FullHttpResponse fullHttpResponse;
    private Channel channel;
    private HttpRequest request;
    private boolean completed = false;

    public void addCookie(Cookie cookie) {
        if (this.cookieLs == null) {
            this.cookieLs = new ArrayList<Cookie>();
        }
        this.cookieLs.add(cookie);
    }

    public void setFullHttpResponse(FullHttpResponse fullHttpResponse) {
        this.fullHttpResponse = fullHttpResponse;
    }

    public void setChannelHandlerContext(Channel channel) {
        this.channel = channel;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public void setHeader(String name, String value) {
        this.fullHttpResponse.headers().set(name, (Object)value);
    }

    public void addHeader(String name, String value) {
        this.fullHttpResponse.headers().add(name, (Object)value);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public void handleFile(String realFilePath, boolean viewMode, String fileName) {
        if (realFilePath == null) {
            RegionHttpResponse.sendError(this.channel, HttpResponseStatus.NOT_FOUND);
            return;
        }
        try {
            File file = new File(realFilePath);
            if (!file.exists() || file.isDirectory()) {
                RegionHttpResponse.sendError(this.channel, HttpResponseStatus.NOT_FOUND);
                return;
            }
            if (fileName == null) {
                fileName = file.getName();
            }
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            long fileLength = raf.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
            RegionHttpResponse.setContentTypeHeader((HttpResponse)response, file);
            response.headers().add("Date", (Object)new Date());
            response.headers().add("Transfer-Encoding", (Object)"chunked");
            response.headers().add("Server", (Object)"RegionSoft/V0.5.1.2");
            response.headers().add("last-modified", (Object)new Date(file.lastModified()));
            if (viewMode) {
                response.headers().add("Content-Disposition", (Object)("inline; filename=" + file.getName()));
            } else {
                try {
                    response.headers().add("Content-Disposition", (Object)("attachment; filename=" + URLEncoder.encode(fileName, "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        response.headers().add("Content-Disposition", (Object)("attachment; filename=" + URLEncoder.encode(fileName, "UTF-16")));
                    }
                    catch (UnsupportedEncodingException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (HttpUtil.isKeepAlive((HttpMessage)this.request)) {
                response.headers().set("CONNECTION", (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            this.channel.write((Object)response);
            ChannelFuture sendFileFuture = this.channel.pipeline().get(SslHandler.class) == null ? this.channel.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)this.channel.newProgressivePromise()) : this.channel.write((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)this.channel.newProgressivePromise());
            sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                    if (total < 0L) {
                        // empty if block
                    }
                }

                public void operationComplete(ChannelProgressiveFuture future) {
                }
            });
            ChannelFuture lastContentFuture = this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            if (!HttpUtil.isKeepAlive((HttpMessage)this.request)) {
                lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (FileNotFoundException ignore) {
            RegionHttpResponse.sendError(this.channel, HttpResponseStatus.NOT_FOUND);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.completed = true;
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String a = mimeTypesMap.getContentType(file.getPath());
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mimeTypesMap.getContentType(file.getPath()));
    }

    public void setContentType(String type) {
        this.fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)type);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public List<Cookie> getCookieLs() {
        return this.cookieLs;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public String getContentType() {
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public void setCharacterEncoding(String charset) {
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
    }

    public Locale getLocale() {
        return null;
    }

    public boolean containsHeader(String name) {
        return false;
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
    }

    public void sendError(int sc) throws IOException {
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
    }

    public void addDateHeader(String name, long date) {
    }

    public void setIntHeader(String name, int value) {
    }

    public void addIntHeader(String name, int value) {
    }

    public void setStatus(int sc) {
        this.fullHttpResponse.setStatus(new HttpResponseStatus(sc, ""));
    }

    public void setStatus(int sc, String sm) {
    }

    public int getStatus() {
        return 0;
    }

    public String getHeader(String name) {
        return null;
    }

    public Collection<String> getHeaders(String name) {
        return null;
    }

    public Collection<String> getHeaderNames() {
        return null;
    }

    private static void sendError(Channel channel, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        channel.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

