/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.common.AESUtil;
import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.dispatcher.ProcessResponseWrapper;
import cn.regionsoft.one.core.dispatcher.WebRequestProcessor;
import cn.regionsoft.one.properties.ConfigUtil;
import cn.regionsoft.one.standalone.HttpServer;
import cn.regionsoft.one.standalone.RegionHttpRequest;
import cn.regionsoft.one.standalone.RegionHttpResponse;
import cn.regionsoft.one.standalone.UploadMsg;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;

public class NettyHttpUtil {
    public static Logger logger = Logger.getLogger(NettyHttpUtil.class);
    private static int contextLength = -1;
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String EQUAL = "=";
    private static final String AND = "&";
    private static final String QUESTION = "?";
    private static final String ORIGIN = "Origin";
    private static final String REFERER = "Referer";
    private static final String COOKIE = "Cookie";
    private static final String COOKIE2 = "cookie";
    private static final String SEMICOLON = ";";
    private static final String SLASH = "/";
    private static final String HTTPONLY = "HttpOnly";
    private static final String EXPIRES = "Expires";
    private static final String PATH = "Path";
    private static final String EQUAL2 = "==";
    private static final String SERVER = "Server";
    private static final String REGION_V = "RegionSoft/V0.5.1.2";
    private static final String DATE = "Date";
    private static final String ACAM = "Access-Control-Allow-Methods";
    private static final String ACMA = "Access-Control-Max-Age";
    private static final String ACAH = "Access-Control-Allow-Headers";
    private static final String XRW = "x-requested-with";
    private static final String ACAO = "Access-Control-Allow-Origin";
    private static final String ACAOALL = "*";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String ACAC = "Access-Control-Allow-Credentials";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String ACEH = "Access-Control-Expose-Headers";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processNettyMsg(Channel channel, String contextPath, HttpRequest request, Object msg) throws Exception {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        DefaultFullHttpResponse response = null;
        try {
            String referer;
            String origin;
            String[] responseHeader;
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            ProcessResponseWrapper prw = NettyHttpUtil.processMsg(contextPath, request, msg, (FullHttpResponse)response, channel);
            if (prw.isCompleted()) {
                return;
            }
            String resStr = (String)prw.getResponse();
            if (resStr != null) {
                if (prw.isEncript()) {
                    resStr = AESUtil.encriptCBC(resStr, ConfigUtil.getProperty("aes.key"), ConfigUtil.getProperty("aes.iv"));
                }
                response.content().writeCharSequence((CharSequence)resStr, Charset.forName("UTF-8"));
            }
            if ((responseHeader = prw.getResponseHeader()) != null) {
                for (String tmpHeader : responseHeader) {
                    String[] tmpArray = tmpHeader.split(EQUAL2);
                    if (tmpArray == null || tmpArray.length != 2) continue;
                    response.headers().set(tmpArray[0].trim(), (Object)tmpArray[1].trim());
                }
            }
            if (prw.isEncript()) {
                response.headers().set(CONTENT_TYPE, (Object)TEXT_PLAIN);
                response.headers().set("encrypt", (Object)true);
                response.headers().set(ACEH, (Object)"encrypt");
            }
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().set(SERVER, (Object)REGION_V);
            response.headers().set(ACAM, (Object)"POST,GET,OPTIONS");
            response.headers().set(ACMA, (Object)"3600");
            response.headers().set(ACAO, (Object)ACAOALL);
            List<Cookie> cookieLs = prw.getHttprequestResponse().getCookieLs();
            if (cookieLs != null) {
                StringBuilder sb = null;
                Date expireDt = null;
                for (Cookie tmp : cookieLs) {
                    sb = new StringBuilder();
                    sb.append(tmp.getName());
                    sb.append(EQUAL);
                    sb.append(tmp.getValue());
                    if (tmp.getMaxAge() > 0) {
                        sb.append(SEMICOLON);
                        sb.append(EXPIRES);
                        sb.append(EQUAL);
                        Date now = new Date();
                        expireDt = new Date(now.getTime() + (long)(tmp.getMaxAge() * 1000));
                        sb.append(expireDt.toString());
                    }
                    if (!CommonUtil.isEmpty(tmp.getPath())) {
                        sb.append(SEMICOLON);
                        sb.append(PATH);
                        sb.append(EQUAL);
                        sb.append(tmp.getPath());
                    }
                    if (tmp.isHttpOnly()) {
                        sb.append(SEMICOLON);
                        sb.append(HTTPONLY);
                    }
                    response.headers().add(SET_COOKIE, (Object)sb.toString());
                }
            }
            if ((origin = request.headers().get(ORIGIN)) != null) {
                response.headers().set(ACAO, (Object)origin);
            } else if (request.headers() != null && (referer = request.headers().get(REFERER)) != null) {
                String[] ar = referer.split(SLASH, 4);
                String refererStr = ar[0] + SLASH + ar[1] + SLASH + ar[2];
                response.headers().set(ACAO, (Object)refererStr);
            }
            response.headers().set(ACAC, (Object)"true");
        }
        catch (Exception e) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            response.content().writeCharSequence((CharSequence)CommonUtil.constructStackTrace(e), Charset.forName("UTF-8"));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        }
        finally {
            try {
                if (keepAlive) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                }
                channel.writeAndFlush((Object)response);
                if (!keepAlive) {
                    channel.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        String url = "http://localhost:18080/SilverFrontend/core/v.html?/comp/config/configlist.html";
        Pattern p = Pattern.compile("(http://|https://)[^.]*?/", 2);
        Matcher matcher = p.matcher(url);
        matcher.find();
        System.out.println(matcher.group());
    }

    private static ProcessResponseWrapper processMsg(String contextPath, HttpRequest request, Object msg, FullHttpResponse response, Channel channel) throws Exception {
        String contentMsg = null;
        UploadMsg uploadMsg = null;
        if (msg instanceof String) {
            contentMsg = (String)msg;
        } else if (msg instanceof UploadMsg) {
            uploadMsg = (UploadMsg)msg;
        }
        String reqURI = request.uri();
        if (!reqURI.startsWith(contextPath)) {
            throw new Exception("request path is invalid");
        }
        if (contextLength == -1) {
            contextLength = contextPath.length();
        }
        reqURI = reqURI.substring(contextLength, reqURI.length());
        HashMap<String, String[]> requestMap = new HashMap<String, String[]>();
        int hasPara = reqURI.indexOf(QUESTION);
        String paraStr = null;
        if (hasPara != -1) {
            paraStr = reqURI.substring(hasPara + 1);
            reqURI = reqURI.substring(0, hasPara);
            if (!CommonUtil.isEmpty(paraStr)) {
                String[] paraArray = paraStr.split(AND);
                String[] paraPair = null;
                for (String tmp : paraArray) {
                    paraPair = tmp.split(EQUAL);
                    if (paraPair.length != 2) continue;
                    requestMap.put(paraPair[0], new String[]{URLDecoder.decode(paraPair[1], HttpServer.REQUEST_ENCODING.name())});
                }
                paraStr = null;
            }
        }
        String method = null;
        if (request.method() == HttpMethod.POST) {
            method = POST;
            paraStr = contentMsg;
        } else {
            method = request.method() == HttpMethod.GET ? GET : POST;
        }
        if (!CommonUtil.isEmpty(paraStr)) {
            String[] paraArray = paraStr.split(AND);
            String[] paraPair = null;
            for (String tmp : paraArray) {
                paraPair = tmp.split(EQUAL);
                if (paraPair.length != 2) continue;
                requestMap.put(paraPair[0], new String[]{URLDecoder.decode(paraPair[1], HttpServer.REQUEST_ENCODING.name())});
            }
        }
        HashMap<String, String> headerInfo = new HashMap<String, String>();
        HttpHeaders headers = request.headers();
        Iterator iterator = headers.iteratorAsString();
        Map.Entry tmp = null;
        while (iterator.hasNext()) {
            tmp = (Map.Entry)iterator.next();
            headerInfo.put((String)tmp.getKey(), (String)tmp.getValue());
        }
        HashMap<String, String> cookiesMap = new HashMap<String, String>();
        String cookieStr = (String)headerInfo.get(COOKIE);
        if (cookieStr == null) {
            cookieStr = (String)headerInfo.get(COOKIE2);
        }
        if (cookieStr != null) {
            String[] cookieArray;
            for (String tmpCookie : cookieArray = cookieStr.split(SEMICOLON)) {
                String[] tmpArray = tmpCookie.split(EQUAL);
                cookiesMap.put(tmpArray[0].trim(), tmpArray[1].trim());
            }
        }
        RegionHttpRequest httprequest = new RegionHttpRequest();
        httprequest.setHeaderInfo(headerInfo);
        httprequest.setCookiesMap(cookiesMap);
        httprequest.setRequestMap(requestMap);
        httprequest.setMethod(method);
        if (uploadMsg != null) {
            httprequest.setUploadMsg(uploadMsg);
        }
        RegionHttpResponse httprequestResponse = new RegionHttpResponse();
        httprequestResponse.setFullHttpResponse(response);
        httprequestResponse.setRequest(request);
        httprequestResponse.setChannelHandlerContext(channel);
        ProcessResponseWrapper prw = WebRequestProcessor.process(reqURI, method, requestMap, headerInfo, cookiesMap, httprequest, httprequestResponse);
        prw.setCompleted(httprequestResponse.isCompleted());
        prw.setHttprequestResponse(httprequestResponse);
        return prw;
    }
}

