/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.event.HttpFileEventListener;
import cn.regionsoft.one.event.HttpMsgEventListener;
import cn.regionsoft.one.standalone.HttpServer;
import cn.regionsoft.one.standalone.NettyHttpUtil;
import cn.regionsoft.one.standalone.UploadMsg;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.Future;

public class HttpServerRequestHandler
extends ChannelInboundHandlerAdapter {
    private static AttributeKey<Integer> CHANNEL_UUID = AttributeKey.valueOf((String)"channelUuid");
    private final String currContextPath;
    private HttpRequest currRequest;

    public HttpServerRequestHandler(String contextPath) {
        this.currContextPath = contextPath;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof String) {
            int syncCount = HttpServer.syncCount.get();
            if (syncCount > 300) {
                HttpMsgEventListener.Event event = new HttpMsgEventListener.Event();
                HttpMsgEventListener.EventData eventData = new HttpMsgEventListener.EventData(ctx.channel(), this.currContextPath, this.currRequest, msg);
                event.setData(eventData);
                event.publish();
            } else {
                HttpServer.syncCount.incrementAndGet();
                NettyHttpUtil.processNettyMsg(ctx.channel(), this.currContextPath, this.currRequest, msg);
                syncCount = HttpServer.syncCount.decrementAndGet();
            }
        } else if (msg instanceof HttpRequest) {
            this.currRequest = (HttpRequest)msg;
        } else if (msg instanceof UploadMsg) {
            this.currRequest = ((UploadMsg)msg).getCurrRequest();
            HttpFileEventListener.Event event = new HttpFileEventListener.Event();
            HttpFileEventListener.EventData eventData = new HttpFileEventListener.EventData(ctx.channel(), this.currContextPath, this.currRequest, msg);
            event.setData(eventData);
            Future future = event.publish();
        } else {
            ReferenceCountUtil.release((Object)msg);
        }
    }
}

