/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.standalone.HttpComposeHandler;
import cn.regionsoft.one.standalone.HttpFileUploadHandler;
import cn.regionsoft.one.standalone.HttpServer;
import cn.regionsoft.one.standalone.HttpServerRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class HttpNIOServer
implements HttpServer {
    private static final Logger logger = Logger.getLogger(HttpNIOServer.class);
    static final Map<Integer, Channel> channelMap = new ConcurrentHashMap<Integer, Channel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int port, final String contextPath, final KeyManagerFactory kmf) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(2);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(4);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (kmf != null) {
                        SSLContext sslcontext = SSLContext.getInstance("TLS");
                        sslcontext.init(kmf.getKeyManagers(), null, null);
                        SSLEngine sslEngine = sslcontext.createSSLEngine();
                        sslEngine.setUseClientMode(false);
                        sslEngine.setNeedClientAuth(false);
                        pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(60L, TimeUnit.SECONDS)});
                    pipeline.addLast(new ChannelHandler[]{new WriteTimeoutHandler(60L, TimeUnit.SECONDS)});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    if (kmf != null) {
                        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpFileUploadHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpComposeHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpServerRequestHandler(contextPath)});
                }
            }).option(ChannelOption.SO_BACKLOG, (Object)256)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator())).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = b.bind(port).sync();
            logger.debug("Regionsoft Server listening on " + port + " ...");
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> HttpNIOServer.lambda$start$0((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup)));
        }
    }

    public static void main(String[] args) throws Exception {
        HttpNIOServer server = new HttpNIOServer();
        System.out.println("Http Server listening on 8844 ...");
        server.start(8844, "/MorcbleFrontend", null);
    }

    private static /* synthetic */ void lambda$start$0(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
    }
}

