/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.common.Constants;
import cn.regionsoft.one.core.CommonUtil;
import cn.regionsoft.one.core.ids.IDGenerator;
import cn.regionsoft.one.standalone.HttpServer;
import cn.regionsoft.one.standalone.UploadMsg;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class HttpFileUploadHandler
extends ChannelInboundHandlerAdapter {
    private HttpRequest currRequest;
    private byte[] boundary = null;
    private String fileName = null;
    private boolean fileUploadFlag = false;
    private static final String FILE_CONTENT_TYPE = "multipart/form-data";
    private File tmpFile = null;
    private FileOutputStream fos = null;
    private FileChannel fileChannel = null;
    private static String tmpFileFolderPath = Constants.FILE_SERVER_ROOT + Constants.SYSTEM_SEPERATOR + "tmp" + Constants.SYSTEM_SEPERATOR;

    private void resolveIncomingByteBuf(ByteBuf incomingByteBuf) {
        if (this.tmpFile == null) {
            try {
                File folder = new File(tmpFileFolderPath);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                this.fileName = String.valueOf(IDGenerator.generateSnowflakeID());
                this.tmpFile = new File(tmpFileFolderPath + this.fileName);
                this.fos = new FileOutputStream(this.tmpFile);
                this.fileChannel = this.fos.getChannel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.fos != null) {
            try {
                this.fileChannel.write(incomingByteBuf.nioBuffer());
                incomingByteBuf.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.currRequest = (HttpRequest)msg;
            String contentType = this.currRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (contentType != null && contentType.startsWith(FILE_CONTENT_TYPE)) {
                String boundaryStr = contentType.split(";")[1].split("=")[1];
                this.boundary = boundaryStr.getBytes(HttpServer.REQUEST_ENCODING.name());
                this.fileUploadFlag = true;
            } else {
                ctx.fireChannelRead(msg);
            }
        } else if (this.fileUploadFlag) {
            if (msg instanceof HttpContent) {
                if (msg instanceof LastHttpContent) {
                    this.resolveIncomingByteBuf(((DefaultLastHttpContent)msg).content());
                    UploadMsg uploadMsg = new UploadMsg(this.boundary, this.fileName, this.currRequest);
                    CommonUtil.closeQuietly(this.fileChannel);
                    CommonUtil.closeQuietly(this.fos);
                    this.reset();
                    ctx.fireChannelRead((Object)uploadMsg);
                } else {
                    this.resolveIncomingByteBuf(((DefaultHttpContent)msg).content());
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void reset() {
        this.tmpFile = null;
        this.fos = null;
        this.fileChannel = null;
        this.fileUploadFlag = false;
        this.boundary = null;
        this.fileName = null;
    }
}

