/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.common.Logger;
import cn.regionsoft.one.standalone.HttpComposeHandler;
import cn.regionsoft.one.standalone.HttpFileUploadHandler;
import cn.regionsoft.one.standalone.HttpServer;
import cn.regionsoft.one.standalone.HttpServerRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.ResourceLeakDetector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class HttpEpollServer
implements HttpServer {
    private static final Logger logger = Logger.getLogger(HttpEpollServer.class);
    static final Map<Integer, Channel> channelMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int port, final String contextPath, final KeyManagerFactory kmf) throws Exception {
        EpollEventLoopGroup bossGroup = new EpollEventLoopGroup(1);
        EpollEventLoopGroup workerGroup = new EpollEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(EpollServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<EpollSocketChannel>(){

                public void initChannel(EpollSocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (kmf != null) {
                        SSLContext sslcontext = SSLContext.getInstance("TLS");
                        sslcontext.init(kmf.getKeyManagers(), null, null);
                        SSLEngine sslEngine = sslcontext.createSSLEngine();
                        sslEngine.setUseClientMode(false);
                        sslEngine.setNeedClientAuth(false);
                        pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
                    }
                    pipeline.addLast(new ChannelHandler[]{new ReadTimeoutHandler(60L, TimeUnit.SECONDS)});
                    pipeline.addLast(new ChannelHandler[]{new WriteTimeoutHandler(60L, TimeUnit.SECONDS)});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
                    if (kmf != null) {
                        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    }
                    pipeline.addLast(new ChannelHandler[]{new HttpFileUploadHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpComposeHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpServerRequestHandler(contextPath)});
                }
            });
            b.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            b.option(ChannelOption.SO_BACKLOG, (Object)8192);
            b.option(ChannelOption.SO_REUSEADDR, (Object)true);
            b.option(ChannelOption.SO_RCVBUF, (Object)262144);
            b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
            b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
            b.childOption(ChannelOption.SO_RCVBUF, (Object)262144);
            b.childOption(ChannelOption.SO_SNDBUF, (Object)262144);
            b.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x100000, 0x200000));
            ChannelFuture f = b.bind(port).sync();
            logger.debug("Regionsoft Server listening on " + port + " ...");
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> HttpEpollServer.lambda$start$0((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup)));
        }
    }

    public static void main(String[] args) throws Exception {
        HttpEpollServer server = new HttpEpollServer();
        System.out.println("Http Server listening on 8844 ...");
        server.start(8844, "/MorcbleFrontend", null);
    }

    private static /* synthetic */ void lambda$start$0(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
    }

    static {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        channelMap = new ConcurrentHashMap<Integer, Channel>();
    }
}

