/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.standalone;

import cn.regionsoft.one.standalone.HttpServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;

public class HttpComposeHandler
extends ChannelInboundHandlerAdapter {
    private ByteBuf bufCache = PooledByteBufAllocator.DEFAULT.buffer();

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            ctx.fireChannelRead(msg);
        } else if (msg instanceof HttpContent) {
            if (this.bufCache.capacity() > 5048576) {
                this.bufCache = this.bufCache.clear();
                ReferenceCountUtil.release((Object)msg);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                response.content().writeCharSequence((CharSequence)"http body is too large ,max body size is 5 MB", Charset.forName("UTF-8"));
                ctx.channel().writeAndFlush((Object)response);
                return;
            }
            HttpContent content = (HttpContent)msg;
            ByteBuf buf = content.content();
            int spaceNeed = buf.capacity() - this.bufCache.writableBytes();
            if (spaceNeed > 0) {
                this.bufCache.capacity(this.bufCache.capacity() + spaceNeed);
            }
            this.bufCache.writeBytes(buf, 0, buf.capacity());
            if (content instanceof LastHttpContent) {
                String contentMsg = this.bufCache.toString(HttpServer.REQUEST_ENCODING);
                this.bufCache = this.bufCache.clear();
                ctx.fireChannelRead((Object)contentMsg);
            }
            ReferenceCountUtil.release((Object)content);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.bufCache.release();
        ctx.fireChannelInactive();
    }
}

