/*
 * Decompiled with CFR 0.152.
 */
package cn.regionsoft.one.serialization.formats.newv;

import cn.regionsoft.one.serialization.formats.core.SeriziDataType;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public class StringFormat {
    public static final byte DATATYPE = (byte)SeriziDataType.String.ordinal();
    public static final Charset CHARSETUTF8 = Charset.forName("UTF-8");

    public static void wrapBytes(String para, ByteBuf byteBuf) {
        int initIndex = byteBuf.readableBytes();
        byteBuf.writeByte((int)DATATYPE);
        byteBuf.writeIntLE(0);
        if (para != null) {
            int length = byteBuf.writeCharSequence((CharSequence)para, CHARSETUTF8);
            byteBuf.setIntLE(initIndex + 1, length);
        }
    }

    public static ByteBuf getBytes(String para, ByteBuf byteBuf) {
        byteBuf.writeByte((int)DATATYPE);
        byteBuf.writeIntLE(0);
        if (para != null) {
            int length = byteBuf.writeCharSequence((CharSequence)para, CHARSETUTF8);
            byteBuf.setIntLE(1, length);
        }
        return byteBuf;
    }

    public static String getValFromSerialized(ByteBuf byteBuf, int skipBytes, int length) {
        if (skipBytes > 0) {
            byteBuf.skipBytes(skipBytes);
        }
        byte[] result = new byte[length];
        byteBuf.readBytes(result);
        return new String(result, CHARSETUTF8);
    }
}

